package com.ifourthwall.dbm.provider.dto.space;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 * @author xuye
 * Date: 2018年5月30日 下午2:24:58
 */

@Data
@ToString(callSuper=true)
public class ProjectSpaceDTO implements Serializable {

    @ApiModelProperty("流水号")
    private Long id;

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("0 - 生效 1 - 未生效 2 - 删除")
    private String valid;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

    @ApiModelProperty("上级空间id")
    private String parentProjectSpaceId;

    @ApiModelProperty("空间层级")
    private Integer projectSpaceLvl;

    @ApiModelProperty("空间类型1 区域 2 大楼 3 楼层 4 空间")
    private String projectSpaceCategoryId;

    @ApiModelProperty("空间标签1公共2租赁3设施4住宅区")
    private String projectSpaceTagId;

    @ApiModelProperty("空间名称")
    private String projectSpaceName;

    @ApiModelProperty("模型名")
    private String u3dModelId;

    @ApiModelProperty("排序")
    private Integer spaceRank;

    @ApiModelProperty("面积平方米")
    private String projectSpaceArea;

    @ApiModelProperty("完整编码（只有最底层空间有）")
    private String detailNo;

    @ApiModelProperty("简略编码")
    private String briefNo;

    @ApiModelProperty("说明")
    private String remark;

    @ApiModelProperty("创建人(user_id)")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新人(user_id)")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "空间属性名")
    private String propName;

    @ApiModelProperty(value = "空间类型名")
    private String categoryName;

    @ApiModelProperty("物件id")
    private String objectId;

    @ApiModelProperty(value = "空间子集合")
    private List<ProjectSpaceDTO> spaceSonList;

    public void pushSpace(ProjectSpaceDTO space) {
        if (this.spaceSonList == null) {
            this.spaceSonList = new ArrayList<>();
        }
        this.spaceSonList.add(space);
    }



}