package com.ifourthwall.dbm.provider.dto.seer;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/3 17:39
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class MerchantSeerStatisticsDTO implements Serializable {

    @ApiModelProperty("商户数")
    private Integer merchantNumber;

    @ApiModelProperty("出租率")
    private BigDecimal rentPercent;

    @ApiModelProperty("商户信息")
    private List<MerchantSeerStatisticsBasisDTO> merchantInfo;

    @ApiModelProperty("商户信息")
    private List<MerchantSeerStatusBasisDTO> merchantStatusInfo;
}
