package com.ifourthwall.dbm.provider.dto.residence;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.AnnexDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/10 14:33
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UpdateResidenceDTO extends BaseReqDTO {


    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("住户状态 (1.未入住 2.已入住 3.装修中 4.出租中 5.出售中 6.其他)")
    @NotEmpty(message = PlatformCodeConstants.STATUS_NOT_NULL)
    private String residenceStatusId;

    @ApiModelProperty("住户业主名称")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_OWNER_NAME_NOT_NULL)
    private String residenceOwnerName;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

    @ApiModelProperty("用户关系id")
    private String userRelationshipId;

    @ApiModelProperty("住户id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_ID_NOT_NULL)
    private String residenceId;

    @ApiModelProperty("住户人员id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_MEMBER_ID_NOT_NULL)
    private String residenceMemberId;

    @ApiModelProperty("业主身份证")
    private String residenceOwnerIdCard;

    @ApiModelProperty("业主手机号")
    @NotEmpty(message = PlatformCodeConstants.OWNER_PHONE_NOT_NULL)
    private String residenceOwnerPhone;

    @ApiModelProperty("小程序背景图")
    private String backgroundPic;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者user_id")
    private String updateBy;

    @ApiModelProperty("有效期限")
    private Date contractBegin;

    @ApiModelProperty("入住时间")
    private Date contractEnd;

    @ApiModelProperty("空间id")
    @NotEmpty(message = PlatformCodeConstants.SPACE_ID_NOT_NULL)
    private List<String> spaceId;

    @ApiModelProperty("合同附件")
    private List<AnnexDTO> merchantAnnexList;

    @ApiModelProperty("其他附件")
    private List<AnnexDTO> annexList;
}
