package com.ifourthwall.dbm.provider.dto.residence;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.merchant.MerchantSpaceInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/11 14:01
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class ResidencePageDTO implements Serializable {

    @ApiModelProperty("住户id")
    private String residenceId;

    @ApiModelProperty("住户状态 (1.未入住 2.已入住 3.装修中 4.出租中 5.出售中 6.其他)")
    private String residenceStatusId;

    @ApiModelProperty("住户状态 (1.未入住 2.已入住 3.装修中 4.出租中 5.出售中 6.其他)")
    private String residenceStatusName;

    @ApiModelProperty("住户业主名称")
    private String residenceOwnerName;

    @ApiModelProperty("业主手机号")
    private String residenceOwnerPhone;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("住户人员id")
    private String residenceMemberId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("空间id")
    private List<MerchantSpaceInfo> spaceInfo;


}
