package com.ifourthwall.dbm.provider.dto.merchant;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/14 14:00
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class MerchantSurrenderDTO extends BaseReqDTO {

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    private String updateBy;
}
