package com.ifourthwall.dbm.provider.dto.estate;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/11/27 10:02
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class ChangeIdentityDTO implements Serializable {

    @ApiModelProperty("token")
    @NotEmpty(message = PlatformCodeConstants.TOKEN_NOT_NULL)
    private String token;

    @ApiModelProperty("商户Id")
    private String merchantId;

    @ApiModelProperty("住户id")
    private String residenceId;

    @ApiModelProperty("项目id（若在首页中切换可不传）")
    private String projectId;

}
