package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.asset.dto.QuerySentryInfoQueryDTO;
import com.ifourthwall.dbm.asset.dto.seer.SentryInfoDTO;
import com.ifourthwall.dbm.asset.dto.sentry.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2021/1/12 14:41
 * @Description:
 */
public interface SentryFacade {

    /**
     * 监测设备占比
     * @Author: YangPeng
     * @Date: 2021/1/12 14:42
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO>
     * @throws
     */
    BaseResponse<MonitorPercentageDTO> monitorPercentage(MonitorPercentageQuDTO query);

    /**
     * 设备完好数量
     * @Author: YangPeng
     * @Date: 2021/1/21 14:22
     * @param sentryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.SentryInfoDTO>
     * @throws
     */
    BaseResponse<SentryInfoDTO> querySentryInfo(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * 设备系统统计
     * @Author: YangPeng
     * @Date: 2021/1/22 15:18
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.sentry.AssetSystemInfoDTO>>
     * @throws
     */
    BaseResponse<List<AssetSystemInfoDTO>> assetSystemInfo(AssetSystemInfoQuDTO query);

    /**
     * 设备监控
     * @Author: YangPeng
     * @Date: 2021/1/22 19:56
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentry.AssetMonitorDTO>
     * @throws
     */
    BaseResponse<AssetMonitorDTO> assetMonitor(AssetMonitorQuDTO query);
}
