package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.app.UpdateAppIdQuDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryMonitorListDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryMonitorListQuDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryMonitorRecordListDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryMonitorRecordListQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 10:45
 * @Description:
 */
public interface MonitorTwoFacade {


    /**
     *  查询监控记录列表（日周月）
     * @Author: YangPeng
     * @Date: 2021/1/11 10:09
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.QueryRecordingListByTimeDTO>>
     * @throws
     */
    BaseResponse<List<QueryRecordingListByTimeDTO>> queryRecordingListByTime(QueryRecordingListByTimeQuDTO query);

    /**
     * 查询设备返修率
     * @Author: YangPeng
     * @Date: 2021/1/11 14:47
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.QueryRecordingRepairDTO>>
     * @throws
     */
    BaseResponse<List<QueryRecordingRepairDTO>> queryRecordingRepair(QueryRecordingRepairQuDTO query);

    /**
     * 查沟通过系统询监控记录列表
     * @Author: YangPeng
     * @Date: 2021/1/19 14:36
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.QueryRecordingListByTimeDTO>>
     * @throws
     */
    BaseResponse<QueryRecordingListBySystemDTO> queryRecordingListBySystem(QueryRecordingListBySystemQuDTO query);

    /**
     * 查询监控对象列表（基本数据）
     * @Author: YangPeng
     * @Date: 2021/1/26 11:01
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.dashboard.QueryMonitorListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryMonitorListDTO>> queryMonitorBasisList(QueryMonitorListQuDTO query);

    /**
     * 查询监控指标列表
     * @Author: YangPeng
     * @Date: 2021/1/26 18:14
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.dashboard.QueryMonitorRecordListDTO>
     * @throws
     */
    BaseResponse<List<QueryMonitorRecordListDTO>> queryMonitorRecordList(QueryMonitorRecordListQuDTO query);
}
