package com.ifourthwall.dbm.asset.dto.metric;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @Author: YangPeng
 * @Date: 2020/10/20 11:22
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SentryCreateTaskDTO extends BaseReqDTO {

    @ApiModelProperty(value = "空间Id")
    @NotBlank(message = "空间Id不能为空")
    private String spaceId;

    @ApiModelProperty(value = "项目id")
    @NotBlank(message = "项目id不能为空")
    private String projectId;

    @NotBlank(message = "任务模版Id不能为空")
    @ApiModelProperty(value = "任务模版id")
    private String taskTemplateId;

    private String alertId;

    @NotBlank(message = "任务描述不能为空")
    @ApiModelProperty(value = "任务描述")
    private String taskDescription;

    @NotBlank(message = "任务名称不能为空")
    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

    @ApiModelProperty("监控记录id")
    private String monitorRecordId;
}
