package com.ifourthwall.dbm.asset.dto.sentry;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2021/1/22 19:52
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class AssetMonitorQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("开始时间")
    @NotEmpty(message = "开始时间不能为空")
    private String startTime;

    @ApiModelProperty("结束时间")
    @NotEmpty(message = "结束时间不能为空")
    private String endTime;

}
