package com.ifourthwall.dbm.asset.dto.sentry;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/3/9 09:50
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class AlertNumberRankingByDateQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("开始时间")
    @NotEmpty(message = "开始时间不能为空")
    private String startTime;

    @ApiModelProperty("结束时间")
    @NotEmpty(message = "结束时间不能为空")
    private String endTime;

    @ApiModelProperty("空间id")
    private String spaceId;

}
