package com.ifourthwall.dbm.asset.dto.seer;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2021/1/11 14:14
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryLineChartRepairQuDTO extends BaseReqDTO {

    @ApiModelProperty("开始时间")
    @NotEmpty(message = "开始时间不能为空")
    private String startTime;

    @ApiModelProperty("结束时间")
    @NotEmpty(message = "结束时间不能为空")
    private String endTime;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("类型 1.今日 2.过去7天 3.过去30天 4.按月份查询  5.按年份查询")
    @NotEmpty(message = PlatformCodeConstants.QUERY_TYPE_CANNOT_NULL)
    private String timeType;
}
