package com.ifourthwall.dbm.asset.dto.dashboard;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.asset.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2021/1/26 10:36
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryMonitorListQuDTO extends PageCommonExTDTO {

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("空间id")
    private List<String> spaceIds;

    @ApiModelProperty("监控名字")
    private String assetName;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("系统id")
    private String assetSystemId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("监控对象标签id")
    private String monitorTargetTagId;

}
