package com.ifourthwall.dbm.asset.dto.app;

import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.asset.dto.FaultItemDTO;
import com.ifourthwall.dbm.asset.dto.MaintenanceItemDTO;
import com.ifourthwall.dbm.asset.dto.MonitorMetricBasisDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/8/28 17:40
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryAssetAppListDTO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetIds;

    @ApiModelProperty("设备故障列表")
    private List<FaultItemDTO> FaultItem;

    @ApiModelProperty("设备事件列表")
    private List<MaintenanceItemDTO> MaintenanceItem;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("空间id")
    private String projectSpaceId;

    @ApiModelProperty("监控点信息")
    private List<CheckMeterDTO> checkMeterInfo;

}
