package com.ifourthwall.dbm.asset.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/1/6 16:20
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpinTagQueryDTO implements Serializable {

    @ApiModelProperty("操作类型 1新增 2修改 3删除")
    private Integer type;

    //新增

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("模板名字")
    private String assetTagName;

    @ApiModelProperty("系统图片url")
    private String assetTagPicture;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("更新者user_id")
    private String updateBy;

    //修改

    @ApiModelProperty("模板id")
    private String assetTagId;

    //删除

    @ApiModelProperty("模板ids")
    private List<String> assetTagIds;
}