package com.ifourthwall.dbm.estate.facade.dto;

import com.ifourthwall.dbm.estate.facade.util.CheckRegexpUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: YangPeng
 * @Date: 2019/8/26 13:47
 * @Description:
 */
@Data
public class ResidenceDTO implements Serializable {

    @ApiModelProperty("住宅规格")
    private String residenceCategory;

    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty("使用面积")
    private BigDecimal usingArea;

    @ApiModelProperty("公用面积")
    private BigDecimal publicArea;

    @ApiModelProperty("更新人id")
    private Integer updateBy;

    @ApiModelProperty("项目id")
    private Integer projectId;

    @ApiModelProperty("空间id")
    private Integer spaceId;

    @ApiModelProperty("空间名称")
    private String name;

}
