package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/9/2 10:54
 * @Description:
 */
@Data
public class EstateBillListQueryDTO extends PageCommonDTO implements Serializable {


    private Integer id;

    /**
     * 业务状态（1：未缴未逾期，2：未缴已逾期，3已缴，4已删除）
     */
    private Integer bizStatus;

    /**
     * 项目id
     */
    @NotNull(message = "项目id不能为空")
    private Integer projectId;

    /**
     * 查询类型
     * 1：代缴账单(valid = 1 and bill_status = 1)，
     * 2：历史账单( bill_status = 2 or valid = -1),
     * 3：历史账单且有效( bill_status = 2 and valid = 1),
     */
    private Integer queryType;

    /**
     * 账单类型(1租赁费，2物业费，3水费，4电费，5煤气费，6公摊费，7其他)，对应字典表estate_bill_category
     */
    private Integer billCategory;

    /**
     * 不动产类型（1:商户，2：住户）
     */
    private Integer estateCategory;

    /**
     * 不动产名称模糊搜索
     */
    private String estateNameLike;

    /**
     * 不动产ids
     */
    private List<String> estateIds;

    /**
     * 状态 （-1：删除，0：无效，1：正常）
     */
    private Integer valid;

    /**
     * 如果userId不为空，
     * 会查询出userId对应ownerId对应的有效的身份对应的不动产进行查询
     */
    private Integer userId;

}
