package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@ToString(callSuper = true)
public class EstateBillBaseDTO  implements Serializable {
    /**
    * 流水号
     */
    private Long id;

    /**
    * 主键id
     */
    private String estateBillId;

    /**
    * 状态 （-1：删除，0：无效，1：正常）
     */
    private Integer valid;

    /**
    * 不动产id
     */
    private String estateId;

    /**
    * 账单类型(1租赁费，2物业费，3水费，4电费，5煤气费，6公摊费，7其他)，对应字典表estate_bill_category
     */
    private Integer billCategory;

    /**
    * 账单编号，后台生成
     */
    private String billNo;

    /**
    * 账单状态(1未缴，2已缴)
     */
    private Integer billStatus;

    /**
    * 账单标题
     */
    private String billTitle;

    /**
    * 账单备注
     */
    private String billRemark;

    /**
    * 收费项1
     */
    private BigDecimal param1;

    /**
    * 收费项2
     */
    private BigDecimal param2;

    /**
    * 应收金额
     */
    private BigDecimal amount;

    /**
    * 应缴日期
     */
    private Date needPayDt;

    /**
    * 实际缴费日期
     */
    private Date actualPayDt;

    /**
    * 创建时间
     */
    private Date createAt;

    /**
    * 创建人id
     */
    private Integer createBy;

    /**
    * 更新时间
     */
    private Date updateAt;

    /**
    * 更新人id
     */
    private Integer updateBy;
}