package com.ifourthwall.dbm.estate.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.*;

import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/8/31 11:49
 * @Description:
 */
public interface EstateResidenceFacade {


    /**
     * 查询住户的产权信息列表
     * @Author: YangPeng
     * @Date: 2019/9/4 17:32
     * @param estateId
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.estate.facade.dto.EstateDTO>
     * @throws
     */
    BaseResponse<List<EstatePropertyDTO>> queryResidenceProperty(EstatePropertyLsitDTO estateId);

    /**
     * 更新不动产住宅信息
     * @Author: YangPeng
     * @Date: 2019/9/11 10:46
     * @param update
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @throws
     */
    BaseResponse<Integer> update(EstatePropertUpdateDTO update);

    /**
     * 获取住宅seer上的统计信息
     * @Author: xuye
     * @Date: 2019/9/26 14:29
     * @param query
     * @return java.util.List<com.ifourthwall.dbm.estate.bo.EstateSeerListBO>
     * @throws
     */
    BaseResponse<EstateResidenceSeerSummaryDTO> getEstateSeerSummary(EstateSeerSummaryQueryDTO query);


}
