/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.fasterxml.classmate.TypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.builders.ResponseBuilder;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.schema.ClassSupport;
import springfox.documentation.schema.WildcardType;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.service.contexts.Orderings;

public class Defaults {
    private HashSet<Class> ignored;
    private LinkedHashMap<RequestMethod, List<ResponseMessage>> responseMessages;
    private Map<HttpMethod, List<Response>> responses = new LinkedHashMap<HttpMethod, List<Response>>();
    private List<Class<? extends Annotation>> annotations;
    private Comparator<Operation> operationOrdering;
    private Comparator<ApiDescription> apiDescriptionOrdering;
    private Comparator<ApiListingReference> apiListingReferenceOrdering;

    public Defaults() {
        this.init();
    }

    public Set<Class> defaultIgnorableParameterTypes() {
        return this.ignored;
    }

    @Deprecated
    public Map<RequestMethod, List<ResponseMessage>> defaultResponseMessages() {
        return this.responseMessages;
    }

    public Map<HttpMethod, List<Response>> defaultResponses() {
        return this.responses;
    }

    public List<Class<? extends Annotation>> defaultExcludeAnnotations() {
        return this.annotations;
    }

    public Comparator<Operation> operationOrdering() {
        return this.operationOrdering;
    }

    public Comparator<ApiDescription> apiDescriptionOrdering() {
        return this.apiDescriptionOrdering;
    }

    public Comparator<ApiListingReference> apiListingReferenceOrdering() {
        return this.apiListingReferenceOrdering;
    }

    public List<AlternateTypeRule> defaultRules(TypeResolver typeResolver) {
        ArrayList<AlternateTypeRule> rules = new ArrayList<AlternateTypeRule>();
        rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve(Map.class, new Type[0]), (Type)typeResolver.resolve(Object.class, new Type[0])));
        rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve(Map.class, new Type[]{String.class, Object.class}), (Type)typeResolver.resolve(Object.class, new Type[0])));
        rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve(Map.class, new Type[]{Object.class, Object.class}), (Type)typeResolver.resolve(Object.class, new Type[0])));
        rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve(ResponseEntity.class, new Type[]{WildcardType.class}), (Type)typeResolver.resolve(WildcardType.class, new Type[0])));
        rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve(HttpEntity.class, new Type[]{WildcardType.class}), (Type)typeResolver.resolve(WildcardType.class, new Type[0])));
        rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve(Optional.class, new Type[]{WildcardType.class}), WildcardType.class));
        this.maybeAddRuleForClassName(typeResolver, rules, "java.util.Optional", WildcardType.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "java.time.LocalDate", Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "java.time.LocalDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "java.time.Instant", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "java.time.OffsetDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "java.time.ZonedDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.threeten.bp.LocalDate", Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.threeten.bp.LocalDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.threeten.bp.Instant", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.threeten.bp.OffsetDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.threeten.bp.ZonedDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.LocalDate", Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.LocalDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.Instant", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.DateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.ReadableDateTime", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.ReadableInstant", java.util.Date.class);
        this.maybeAddRuleForClassName(typeResolver, rules, "org.joda.time.DateMidnight", java.util.Date.class);
        return rules;
    }

    private void maybeAddRuleForClassName(TypeResolver typeResolver, List<AlternateTypeRule> rules, String className, Class<?> clazz) {
        Optional fromClazz = ClassSupport.classByName((String)className);
        fromClazz.ifPresent(aClass -> rules.add(AlternateTypeRules.newRule((Type)typeResolver.resolve((Type)aClass, new Type[0]), (Type)typeResolver.resolve((Type)clazz, new Type[0]))));
    }

    private void init() {
        this.initIgnorableTypes();
        this.initResponseMessages();
        this.initResponses();
        this.initExcludeAnnotations();
        this.initOrderings();
    }

    private void initResponses() {
        this.responses = new LinkedHashMap<HttpMethod, List<Response>>();
        this.responses.put(HttpMethod.GET, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.OK.value())).description(HttpStatus.OK.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.NOT_FOUND.value())).description(HttpStatus.NOT_FOUND.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.PUT, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.CREATED.value())).description(HttpStatus.CREATED.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.NOT_FOUND.value())).description(HttpStatus.NOT_FOUND.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.POST, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.CREATED.value())).description(HttpStatus.CREATED.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.NOT_FOUND.value())).description(HttpStatus.NOT_FOUND.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.DELETE, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.NO_CONTENT.value())).description(HttpStatus.NO_CONTENT.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.PATCH, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.NO_CONTENT.value())).description(HttpStatus.NO_CONTENT.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.TRACE, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.NO_CONTENT.value())).description(HttpStatus.NO_CONTENT.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.OPTIONS, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.NO_CONTENT.value())).description(HttpStatus.NO_CONTENT.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
        this.responses.put(HttpMethod.HEAD, Arrays.asList(new ResponseBuilder().code(String.valueOf(HttpStatus.NO_CONTENT.value())).description(HttpStatus.NO_CONTENT.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.FORBIDDEN.value())).description(HttpStatus.FORBIDDEN.getReasonPhrase()).build(), new ResponseBuilder().code(String.valueOf(HttpStatus.UNAUTHORIZED.value())).description(HttpStatus.UNAUTHORIZED.getReasonPhrase()).build()));
    }

    private void initOrderings() {
        this.operationOrdering = Orderings.positionComparator().thenComparing(Orderings.nickNameComparator());
        this.apiDescriptionOrdering = Orderings.apiPathCompatator();
        this.apiListingReferenceOrdering = Orderings.listingPositionComparator().thenComparing(Orderings.listingReferencePathComparator());
    }

    private void initExcludeAnnotations() {
        this.annotations = new ArrayList<Class<? extends Annotation>>();
        this.annotations.add(ApiIgnore.class);
    }

    private void initIgnorableTypes() {
        this.ignored = new HashSet();
        this.ignored.add(Class.class);
        this.ignored.add(Void.class);
        this.ignored.add(Void.TYPE);
        this.ignored.add(HttpHeaders.class);
        this.ignored.add(BindingResult.class);
        this.ignored.add(UriComponentsBuilder.class);
        this.ignored.add(ApiIgnore.class);
        this.classFor("javax.servlet.ServletRequest").ifPresent(it -> this.ignored.add((Class)it));
        this.classFor("javax.servlet.ServletResponse").ifPresent(it -> this.ignored.add((Class)it));
        this.classFor("javax.servlet.http.HttpServletRequest").ifPresent(it -> this.ignored.add((Class)it));
        this.classFor("javax.servlet.http.HttpServletResponse").ifPresent(it -> this.ignored.add((Class)it));
        this.classFor("javax.servlet.ServletContext").ifPresent(it -> this.ignored.add((Class)it));
    }

    Optional<Class> classFor(String className) {
        try {
            return Optional.of(Class.forName(className, false, this.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private void initResponseMessages() {
        this.responseMessages = new LinkedHashMap();
        this.responseMessages.put(RequestMethod.GET, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.OK.value()).message(HttpStatus.OK.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.NOT_FOUND.value()).message(HttpStatus.NOT_FOUND.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.PUT, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.CREATED.value()).message(HttpStatus.CREATED.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.NOT_FOUND.value()).message(HttpStatus.NOT_FOUND.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.POST, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.CREATED.value()).message(HttpStatus.CREATED.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.NOT_FOUND.value()).message(HttpStatus.NOT_FOUND.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.DELETE, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.PATCH, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.TRACE, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.OPTIONS, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
        this.responseMessages.put(RequestMethod.HEAD, Arrays.asList(new ResponseMessageBuilder().code(HttpStatus.NO_CONTENT.value()).message(HttpStatus.NO_CONTENT.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.FORBIDDEN.value()).message(HttpStatus.FORBIDDEN.getReasonPhrase()).responseModel(null).build(), new ResponseMessageBuilder().code(HttpStatus.UNAUTHORIZED.value()).message(HttpStatus.UNAUTHORIZED.getReasonPhrase()).responseModel(null).build()));
    }
}

