/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface WebSocketSession {
    public String getId();

    public HandshakeInfo getHandshakeInfo();

    public DataBufferFactory bufferFactory();

    public Map<String, Object> getAttributes();

    public Flux<WebSocketMessage> receive();

    public Mono<Void> send(Publisher<WebSocketMessage> var1);

    default public Mono<Void> close() {
        return this.close(CloseStatus.NORMAL);
    }

    public Mono<Void> close(CloseStatus var1);

    public WebSocketMessage textMessage(String var1);

    public WebSocketMessage binaryMessage(Function<DataBufferFactory, DataBuffer> var1);

    public WebSocketMessage pingMessage(Function<DataBufferFactory, DataBuffer> var1);

    public WebSocketMessage pongMessage(Function<DataBufferFactory, DataBuffer> var1);
}

