/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.net.URI;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class ServerWebExchangeMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public ServerWebExchangeMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterTypeNoReactiveWrapper(parameter, type -> ServerWebExchange.class.isAssignableFrom((Class<?>)type) || ServerHttpRequest.class.isAssignableFrom((Class<?>)type) || ServerHttpResponse.class.isAssignableFrom((Class<?>)type) || HttpMethod.class == type || Locale.class == type || TimeZone.class == type || ZoneId.class == type || UriBuilder.class == type || UriComponentsBuilder.class == type);
    }

    @Override
    public Object resolveArgumentValue(MethodParameter methodParameter, BindingContext context, ServerWebExchange exchange) {
        Class paramType = methodParameter.getParameterType();
        if (ServerWebExchange.class.isAssignableFrom(paramType)) {
            return exchange;
        }
        if (ServerHttpRequest.class.isAssignableFrom(paramType)) {
            return exchange.getRequest();
        }
        if (ServerHttpResponse.class.isAssignableFrom(paramType)) {
            return exchange.getResponse();
        }
        if (HttpMethod.class == paramType) {
            return exchange.getRequest().getMethod();
        }
        if (Locale.class == paramType) {
            return exchange.getLocaleContext().getLocale();
        }
        if (TimeZone.class == paramType) {
            LocaleContext localeContext = exchange.getLocaleContext();
            TimeZone timeZone = this.getTimeZone(localeContext);
            return timeZone != null ? timeZone : TimeZone.getDefault();
        }
        if (ZoneId.class == paramType) {
            LocaleContext localeContext = exchange.getLocaleContext();
            TimeZone timeZone = this.getTimeZone(localeContext);
            return timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault();
        }
        if (UriBuilder.class == paramType || UriComponentsBuilder.class == paramType) {
            URI uri = exchange.getRequest().getURI();
            return UriComponentsBuilder.fromUri((URI)uri).replacePath(null).replaceQuery(null);
        }
        throw new IllegalArgumentException("Unknown parameter type: " + paramType + " in method: " + methodParameter.getMethod());
    }

    @Nullable
    private TimeZone getTimeZone(LocaleContext localeContext) {
        TimeZone timeZone = null;
        if (localeContext instanceof TimeZoneAwareLocaleContext) {
            timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone();
        }
        return timeZone;
    }
}

