/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HandshakeInfo {
    private final URI uri;
    private final Mono<Principal> principalMono;
    private final HttpHeaders headers;
    @Nullable
    private final String protocol;
    @Nullable
    private final InetSocketAddress remoteAddress;
    private final Map<String, Object> attributes;
    @Nullable
    private final String logPrefix;

    public HandshakeInfo(URI uri, HttpHeaders headers2, Mono<Principal> principal, @Nullable String protocol) {
        this(uri, headers2, principal, protocol, null, Collections.emptyMap(), null);
    }

    public HandshakeInfo(URI uri, HttpHeaders headers2, Mono<Principal> principal, @Nullable String protocol, @Nullable InetSocketAddress remoteAddress, Map<String, Object> attributes, @Nullable String logPrefix) {
        Assert.notNull((Object)uri, (String)"URI is required");
        Assert.notNull((Object)headers2, (String)"HttpHeaders are required");
        Assert.notNull(principal, (String)"Principal is required");
        Assert.notNull(attributes, (String)"'attributes' is required");
        this.uri = uri;
        this.headers = headers2;
        this.principalMono = principal;
        this.protocol = protocol;
        this.remoteAddress = remoteAddress;
        this.attributes = attributes;
        this.logPrefix = logPrefix;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Mono<Principal> getPrincipal() {
        return this.principalMono;
    }

    @Nullable
    public String getSubProtocol() {
        return this.protocol;
    }

    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public String toString() {
        return "HandshakeInfo[uri=" + this.uri + ", headers=" + this.headers + "]";
    }
}

