/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived;

import java.util.HashMap;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.repository.query.AbstractGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.GraphParametersParameterAccessor;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryCreator;
import org.springframework.data.neo4j.repository.query.derived.DerivedQueryDefinition;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class DerivedGraphRepositoryQuery
extends AbstractGraphRepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(DerivedGraphRepositoryQuery.class);
    private final DerivedQueryDefinition queryDefinition;
    private final GraphQueryMethod graphQueryMethod;
    private final PartTree tree;

    public DerivedGraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        super(graphQueryMethod, session);
        this.graphQueryMethod = graphQueryMethod;
        Class domainType = graphQueryMethod.getEntityInformation().getJavaType();
        this.tree = new PartTree(graphQueryMethod.getName(), domainType);
        this.queryDefinition = (DerivedQueryDefinition)new DerivedQueryCreator(this.tree, domainType).createQuery();
    }

    @Override
    protected Object doExecute(Query params, Object[] parameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing query for method {}", (Object)this.graphQueryMethod.getName());
        }
        GraphParametersParameterAccessor accessor = new GraphParametersParameterAccessor(this.graphQueryMethod, parameters);
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        if (returnType.equals(Void.class)) {
            throw new RuntimeException("Derived Queries must have a return type");
        }
        ResultProcessor processor = this.graphQueryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Object results = this.getExecution(accessor).execute(params, processor.getReturnedType().getDomainType());
        return processor.processResult(results);
    }

    @Override
    protected Query getQuery(Object[] parameters) {
        return new Query(this.resolveParams(parameters));
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    private Filters resolveParams(Object[] parameters) {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (this.graphQueryMethod.getQueryDepthParamIndex() != null && (this.graphQueryMethod.getQueryDepthParamIndex() == null || this.graphQueryMethod.getQueryDepthParamIndex() == i)) continue;
            params.put(i, parameters[i]);
        }
        return new Filters(this.queryDefinition.getFilters(params));
    }
}

