/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.springframework.dao.DataAccessException;
import org.springframework.data.hadoop.hbase.HbaseAccessor;
import org.springframework.data.hadoop.hbase.HbaseOperations;
import org.springframework.data.hadoop.hbase.HbaseUtils;
import org.springframework.data.hadoop.hbase.ResultsExtractor;
import org.springframework.data.hadoop.hbase.RowMapper;
import org.springframework.data.hadoop.hbase.RowMapperResultsExtractor;
import org.springframework.data.hadoop.hbase.TableCallback;
import org.springframework.util.Assert;

public class HbaseTemplate
extends HbaseAccessor
implements HbaseOperations {
    private boolean autoFlush = true;

    public HbaseTemplate() {
    }

    public HbaseTemplate(Configuration configuration) {
        this.setConfiguration(configuration);
        this.afterPropertiesSet();
    }

    @Override
    public <T> T execute(String tableName, TableCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)tableName, (String)"No table specified");
        HTableInterface table = this.getTable(tableName);
        try {
            boolean previousFlushSetting = this.applyFlushSetting(table);
            T result = action.doInTable(table);
            this.flushIfNecessary(table, previousFlushSetting);
            T t = result;
            return t;
        }
        catch (Throwable th) {
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw this.convertHbaseAccessException((Exception)th);
        }
        finally {
            this.releaseTable(tableName, table);
        }
    }

    private HTableInterface getTable(String tableName) {
        return HbaseUtils.getHTable(tableName, this.getConfiguration(), this.getCharset(), this.getTableFactory());
    }

    private void releaseTable(String tableName, HTableInterface table) {
        HbaseUtils.releaseTable(tableName, table, this.getTableFactory());
    }

    private boolean applyFlushSetting(HTableInterface table) {
        boolean autoFlush = table.isAutoFlush();
        if (table instanceof HTable) {
            ((HTable)table).setAutoFlush(this.autoFlush);
        }
        return autoFlush;
    }

    private void restoreFlushSettings(HTableInterface table, boolean oldFlush) {
        if (table instanceof HTable && table.isAutoFlush() != oldFlush) {
            ((HTable)table).setAutoFlush(oldFlush);
        }
    }

    private void flushIfNecessary(HTableInterface table, boolean oldFlush) throws IOException {
        table.flushCommits();
        this.restoreFlushSettings(table, oldFlush);
    }

    public DataAccessException convertHbaseAccessException(Exception ex) {
        return HbaseUtils.convertHbaseException(ex);
    }

    @Override
    public <T> T find(String tableName, String family, ResultsExtractor<T> action) {
        Scan scan = new Scan();
        scan.addFamily(family.getBytes(this.getCharset()));
        return this.find(tableName, scan, action);
    }

    @Override
    public <T> T find(String tableName, String family, String qualifier, ResultsExtractor<T> action) {
        Scan scan = new Scan();
        scan.addColumn(family.getBytes(this.getCharset()), qualifier.getBytes(this.getCharset()));
        return this.find(tableName, scan, action);
    }

    @Override
    public <T> T find(String tableName, final Scan scan, final ResultsExtractor<T> action) {
        return this.execute(tableName, new TableCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInTable(HTableInterface htable) throws Throwable {
                try (ResultScanner scanner = htable.getScanner(scan);){
                    Object t = action.extractData(scanner);
                    return t;
                }
            }
        });
    }

    @Override
    public <T> List<T> find(String tableName, String family, RowMapper<T> action) {
        Scan scan = new Scan();
        scan.addFamily(family.getBytes(this.getCharset()));
        return this.find(tableName, scan, action);
    }

    @Override
    public <T> List<T> find(String tableName, String family, String qualifier, RowMapper<T> action) {
        Scan scan = new Scan();
        scan.addColumn(family.getBytes(this.getCharset()), qualifier.getBytes(this.getCharset()));
        return this.find(tableName, scan, action);
    }

    @Override
    public <T> List<T> find(String tableName, Scan scan, RowMapper<T> action) {
        return (List)this.find(tableName, scan, new RowMapperResultsExtractor<T>(action));
    }

    @Override
    public <T> T get(String tableName, String rowName, RowMapper<T> mapper) {
        return this.get(tableName, rowName, null, null, mapper);
    }

    @Override
    public <T> T get(String tableName, String rowName, String familyName, RowMapper<T> mapper) {
        return this.get(tableName, rowName, familyName, null, mapper);
    }

    @Override
    public <T> T get(String tableName, final String rowName, final String familyName, final String qualifier, final RowMapper<T> mapper) {
        return this.execute(tableName, new TableCallback<T>(){

            @Override
            public T doInTable(HTableInterface htable) throws Throwable {
                Get get = new Get(rowName.getBytes(HbaseTemplate.this.getCharset()));
                if (familyName != null) {
                    byte[] family = familyName.getBytes(HbaseTemplate.this.getCharset());
                    if (qualifier != null) {
                        get.addColumn(family, qualifier.getBytes(HbaseTemplate.this.getCharset()));
                    } else {
                        get.addFamily(family);
                    }
                }
                Result result = htable.get(get);
                return mapper.mapRow(result, 0);
            }
        });
    }

    @Override
    public void put(String tableName, final String rowName, final String familyName, final String qualifier, final byte[] value) {
        Assert.hasLength((String)rowName);
        Assert.hasLength((String)familyName);
        Assert.hasLength((String)qualifier);
        Assert.notNull((Object)value);
        this.execute(tableName, new TableCallback<Object>(){

            @Override
            public Object doInTable(HTableInterface htable) throws Throwable {
                Put put = new Put(rowName.getBytes(HbaseTemplate.this.getCharset())).add(familyName.getBytes(HbaseTemplate.this.getCharset()), qualifier.getBytes(HbaseTemplate.this.getCharset()), value);
                htable.put(put);
                return null;
            }
        });
    }

    @Override
    public void delete(String tableName, String rowName, String familyName) {
        this.delete(tableName, rowName, familyName, null);
    }

    @Override
    public void delete(String tableName, final String rowName, final String familyName, final String qualifier) {
        Assert.hasLength((String)rowName);
        Assert.hasLength((String)familyName);
        this.execute(tableName, new TableCallback<Object>(){

            @Override
            public Object doInTable(HTableInterface htable) throws Throwable {
                Delete delete = new Delete(rowName.getBytes(HbaseTemplate.this.getCharset()));
                byte[] family = familyName.getBytes(HbaseTemplate.this.getCharset());
                if (qualifier != null) {
                    delete.deleteColumn(family, qualifier.getBytes(HbaseTemplate.this.getCharset()));
                } else {
                    delete.deleteFamily(family);
                }
                htable.delete(delete);
                return null;
            }
        });
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }
}

