/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webservices.client;

import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.JdkClientHttpRequestFactoryBuilder;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.webservices.client.WebServiceMessageSenderFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceMessageSender;

@Deprecated(since="3.4.0", forRemoval=true)
public class HttpWebServiceMessageSenderBuilder {
    private ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder;
    private ClientHttpRequestFactorySettings requestFactorySettings = ClientHttpRequestFactorySettings.defaults();

    public HttpWebServiceMessageSenderBuilder setConnectTimeout(Duration connectTimeout) {
        this.requestFactorySettings = this.requestFactorySettings.withConnectTimeout(connectTimeout);
        return this;
    }

    public HttpWebServiceMessageSenderBuilder setReadTimeout(Duration readTimeout) {
        this.requestFactorySettings = this.requestFactorySettings.withReadTimeout(readTimeout);
        return this;
    }

    public HttpWebServiceMessageSenderBuilder sslBundle(SslBundle sslBundle) {
        this.requestFactorySettings = this.requestFactorySettings.withSslBundle(sslBundle);
        return this;
    }

    public HttpWebServiceMessageSenderBuilder requestFactory(Supplier<ClientHttpRequestFactory> requestFactorySupplier) {
        Assert.notNull(requestFactorySupplier, (String)"'requestFactorySupplier' must not be null");
        this.requestFactoryBuilder = ClientHttpRequestFactoryBuilder.of(requestFactorySupplier);
        return this;
    }

    public HttpWebServiceMessageSenderBuilder requestFactory(Function<ClientHttpRequestFactorySettings, ClientHttpRequestFactory> requestFactoryFunction) {
        Assert.notNull(requestFactoryFunction, (String)"'requestFactoryFunction' must not be null");
        this.requestFactoryBuilder = requestFactoryFunction::apply;
        return this;
    }

    public HttpWebServiceMessageSenderBuilder requestFactoryBuilder(ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder) {
        Assert.notNull(requestFactoryBuilder, (String)"'requestFactoryBuilder' must not be null");
        this.requestFactoryBuilder = requestFactoryBuilder;
        return this;
    }

    public WebServiceMessageSender build() {
        ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder = this.getOrDetectRequestFactoryBuilder();
        return WebServiceMessageSenderFactory.http(requestFactoryBuilder, this.requestFactorySettings).getWebServiceMessageSender();
    }

    private ClientHttpRequestFactoryBuilder<?> getOrDetectRequestFactoryBuilder() {
        if (this.requestFactoryBuilder != null) {
            return this.requestFactoryBuilder;
        }
        ClientHttpRequestFactoryBuilder<ClientHttpRequestFactory> builder = ClientHttpRequestFactoryBuilder.detect();
        if (builder instanceof JdkClientHttpRequestFactoryBuilder) {
            return ClientHttpRequestFactoryBuilder.simple();
        }
        return builder;
    }
}

