/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFile;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFileURLStreamHandler;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFiles;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

final class ClassLoaderFilesResourcePatternResolver
implements ResourcePatternResolver {
    private static final String[] LOCATION_PATTERN_PREFIXES = new String[]{"classpath*:", "classpath:"};
    private static final String WEB_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";
    private final ResourcePatternResolver patternResolverDelegate;
    private final PathMatcher antPathMatcher = new AntPathMatcher();
    private final ClassLoaderFiles classLoaderFiles;

    ClassLoaderFilesResourcePatternResolver(ApplicationContext applicationContext, ClassLoaderFiles classLoaderFiles) {
        this.classLoaderFiles = classLoaderFiles;
        this.patternResolverDelegate = this.getResourcePatternResolverFactory().getResourcePatternResolver(applicationContext, this.retrieveResourceLoader(applicationContext));
    }

    private ResourceLoader retrieveResourceLoader(ApplicationContext applicationContext) {
        Field field = ReflectionUtils.findField(applicationContext.getClass(), (String)"resourceLoader", ResourceLoader.class);
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return (ResourceLoader)ReflectionUtils.getField((Field)field, (Object)applicationContext);
    }

    private ResourcePatternResolverFactory getResourcePatternResolverFactory() {
        if (ClassUtils.isPresent((String)WEB_CONTEXT_CLASS, null)) {
            return new WebResourcePatternResolverFactory();
        }
        return new ResourcePatternResolverFactory();
    }

    public ClassLoader getClassLoader() {
        return this.patternResolverDelegate.getClassLoader();
    }

    public Resource getResource(String location) {
        Resource candidate = this.patternResolverDelegate.getResource(location);
        if (this.isDeleted(candidate)) {
            return new DeletedClassLoaderFileResource(location);
        }
        return candidate;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Resource[] candidates;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource candidate : candidates = this.patternResolverDelegate.getResources(locationPattern)) {
            if (this.isDeleted(candidate)) continue;
            resources.add(candidate);
        }
        resources.addAll(this.getAdditionalResources(locationPattern));
        return resources.toArray(new Resource[0]);
    }

    private List<Resource> getAdditionalResources(String locationPattern) throws MalformedURLException {
        ArrayList<Resource> additionalResources = new ArrayList<Resource>();
        String trimmedLocationPattern = this.trimLocationPattern(locationPattern);
        for (ClassLoaderFiles.SourceFolder sourceFolder : this.classLoaderFiles.getSourceFolders()) {
            for (Map.Entry<String, ClassLoaderFile> entry : sourceFolder.getFilesEntrySet()) {
                String name = entry.getKey();
                ClassLoaderFile file = entry.getValue();
                if (entry.getValue().getKind() == ClassLoaderFile.Kind.DELETED || !this.antPathMatcher.match(trimmedLocationPattern, name)) continue;
                URL url = new URL("reloaded", null, -1, "/" + name, new ClassLoaderFileURLStreamHandler(file));
                UrlResource resource = new UrlResource(url);
                additionalResources.add((Resource)resource);
            }
        }
        return additionalResources;
    }

    private String trimLocationPattern(String pattern) {
        for (String prefix : LOCATION_PATTERN_PREFIXES) {
            if (!pattern.startsWith(prefix)) continue;
            return pattern.substring(prefix.length());
        }
        return pattern;
    }

    private boolean isDeleted(Resource resource) {
        for (ClassLoaderFiles.SourceFolder sourceFolder : this.classLoaderFiles.getSourceFolders()) {
            for (Map.Entry<String, ClassLoaderFile> entry : sourceFolder.getFilesEntrySet()) {
                try {
                    String name = entry.getKey();
                    ClassLoaderFile file = entry.getValue();
                    if (file.getKind() != ClassLoaderFile.Kind.DELETED || !resource.exists() || !resource.getURI().toString().endsWith(name)) continue;
                    return true;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to retrieve URI from '" + resource + "'", ex);
                }
            }
        }
        return false;
    }

    private static class WebApplicationContextResourceLoader
    extends DefaultResourceLoader {
        private final WebApplicationContext applicationContext;

        WebApplicationContextResourceLoader(WebApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        protected Resource getResourceByPath(String path) {
            if (this.applicationContext.getServletContext() != null) {
                return new ServletContextResource(this.applicationContext.getServletContext(), path);
            }
            return super.getResourceByPath(path);
        }
    }

    private static class WebResourcePatternResolverFactory
    extends ResourcePatternResolverFactory {
        private WebResourcePatternResolverFactory() {
        }

        @Override
        public ResourcePatternResolver getResourcePatternResolver(ApplicationContext applicationContext, ResourceLoader resourceLoader) {
            if (applicationContext instanceof WebApplicationContext) {
                return this.getResourcePatternResolver((WebApplicationContext)applicationContext, resourceLoader);
            }
            return super.getResourcePatternResolver(applicationContext, resourceLoader);
        }

        private ResourcePatternResolver getResourcePatternResolver(WebApplicationContext applicationContext, ResourceLoader resourceLoader) {
            if (resourceLoader == null) {
                resourceLoader = new WebApplicationContextResourceLoader(applicationContext);
                this.copyProtocolResolvers((ApplicationContext)applicationContext, (ResourceLoader)resourceLoader);
            }
            return new ServletContextResourcePatternResolver(resourceLoader);
        }
    }

    private static class ResourcePatternResolverFactory {
        private ResourcePatternResolverFactory() {
        }

        public ResourcePatternResolver getResourcePatternResolver(ApplicationContext applicationContext, ResourceLoader resourceLoader) {
            if (resourceLoader == null) {
                resourceLoader = new DefaultResourceLoader();
                this.copyProtocolResolvers(applicationContext, resourceLoader);
            }
            return new PathMatchingResourcePatternResolver(resourceLoader);
        }

        protected final void copyProtocolResolvers(ApplicationContext applicationContext, ResourceLoader resourceLoader) {
            if (applicationContext instanceof DefaultResourceLoader && resourceLoader instanceof DefaultResourceLoader) {
                this.copyProtocolResolvers((DefaultResourceLoader)applicationContext, (DefaultResourceLoader)resourceLoader);
            }
        }

        protected final void copyProtocolResolvers(DefaultResourceLoader source, DefaultResourceLoader destination) {
            for (ProtocolResolver resolver : source.getProtocolResolvers()) {
                destination.addProtocolResolver(resolver);
            }
        }
    }

    static final class DeletedClassLoaderFileResource
    extends AbstractResource {
        private final String name;

        private DeletedClassLoaderFileResource(String name) {
            this.name = name;
        }

        public boolean exists() {
            return false;
        }

        public String getDescription() {
            return "Deleted: " + this.name;
        }

        public InputStream getInputStream() throws IOException {
            throw new IOException(this.name + " has been deleted");
        }
    }
}

