/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.openqa.selenium.json.BeanToJsonConverter;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.json.JsonToBeanConverter;

public class Json {
    static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(ListAdapter.access$100()).registerTypeAdapterFactory(MapAdapter.access$000()).setLenient().serializeNulls().disableHtmlEscaping().create();
    public static final Type LIST_OF_MAPS_TYPE = new TypeToken<List<Map<String, Object>>>(){}.getType();
    public static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    public static final Type OBJECT_TYPE = new TypeToken<Object>(){}.getType();
    private final JsonToBeanConverter toBean = new JsonToBeanConverter();
    private final BeanToJsonConverter toJson = new BeanToJsonConverter();

    public String toJson(Object toConvert) {
        return this.toJson.convert(toConvert);
    }

    public JsonElement toJsonElement(Object toConvert) {
        return this.toJson.convertObject(toConvert);
    }

    public <T> T toType(Object source, Class<T> typeOfT) {
        return this.toBean.convert(typeOfT, source);
    }

    public <T> T toType(Object source, Type typeOfT) {
        Class type;
        if (typeOfT instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)typeOfT).getRawType();
        } else if (typeOfT instanceof Class) {
            type = (Class)typeOfT;
        } else {
            throw new IllegalArgumentException("Unable to convert type: " + typeOfT);
        }
        return this.toBean.convert(type, source);
    }

    private static Object readValue(JsonReader in, Gson gson) throws IOException {
        switch (in.peek()) {
            case BEGIN_ARRAY: {
                return gson.fromJson(in, List.class);
            }
            case BEGIN_OBJECT: {
                return gson.fromJson(in, Map.class);
            }
            case BOOLEAN: 
            case NULL: 
            case STRING: {
                return gson.fromJson(in, Object.class);
            }
            case NUMBER: {
                String number = in.nextString();
                if (number.indexOf(46) != -1) {
                    return Double.parseDouble(number);
                }
                return Long.parseLong(number);
            }
        }
        throw new JsonParseException("Unexpected type: " + in.peek());
    }

    public JsonInput newInput(Reader from) throws UncheckedIOException {
        return new JsonInput(GSON, GSON.newJsonReader(from));
    }

    public JsonOutput newOutput(Appendable to) throws UncheckedIOException {
        try {
            return new JsonOutput(this.toJson, GSON.newJsonWriter(CharStreams.asWriter((Appendable)to)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class ListAdapter
    extends TypeAdapter<List<?>> {
        private static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (type.getRawType() == List.class) {
                    return new ListAdapter(gson);
                }
                return null;
            }
        };
        private final Gson gson;

        private ListAdapter(Gson gson) {
            this.gson = Objects.requireNonNull(gson);
        }

        public List<?> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            LinkedList<Object> list = new LinkedList<Object>();
            in.beginArray();
            while (in.hasNext()) {
                list.add(Json.readValue(in, this.gson));
            }
            in.endArray();
            return list;
        }

        public void write(JsonWriter out, List<?> value) throws IOException {
            out.beginArray();
            for (Object entry : value) {
                TypeAdapter adapter = this.gson.getAdapter(entry.getClass());
                adapter.write(out, entry);
            }
            out.endArray();
        }

        static /* synthetic */ TypeAdapterFactory access$100() {
            return FACTORY;
        }
    }

    private static class MapAdapter
    extends TypeAdapter<Map<?, ?>> {
        private static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (type.getRawType() == Map.class) {
                    return new MapAdapter(gson);
                }
                return null;
            }
        };
        private final Gson gson;

        private MapAdapter(Gson gson) {
            this.gson = Objects.requireNonNull(gson);
        }

        public Map<?, ?> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            in.beginObject();
            while (in.hasNext()) {
                String key = in.nextName();
                Object value = Json.readValue(in, this.gson);
                map.put(key, value);
            }
            in.endObject();
            return map;
        }

        public void write(JsonWriter out, Map<?, ?> value) throws IOException {
            out.beginObject();
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                out.name(String.valueOf(entry.getKey()));
                TypeAdapter adapter = this.gson.getAdapter(entry.getValue().getClass());
                adapter.write(out, entry.getValue());
            }
            out.endObject();
        }

        static /* synthetic */ TypeAdapterFactory access$000() {
            return FACTORY;
        }
    }
}

