/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.io.IOException;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    private final CloseableHttpClient httpClient;
    private final int TIMEOUT_THREE_HOURS = (int)TimeUnit.SECONDS.toMillis(10800L);
    private final HttpClientConnectionManager gridClientConnectionManager = HttpClientFactory.getClientConnectionManager();

    public HttpClientFactory() {
        this.httpClient = this.createHttpClient(null);
    }

    private static HttpClientConnectionManager getClientConnectionManager() {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setMaxTotal(2000);
        cm.setDefaultMaxPerRoute(2000);
        return cm;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public CloseableHttpClient createHttpClient(Credentials credentials) {
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager(HttpClientFactory.getClientConnectionManager()).setDefaultSocketConfig(this.createSocketConfig()).setDefaultSocketConfig(this.createSocketConfig()).setRoutePlanner(this.createRoutePlanner()).setDefaultRequestConfig(this.createRequestConfig());
        if (credentials != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder.build();
    }

    public HttpClient getGridHttpClient(int connection_timeout, int socket_timeout) {
        this.gridClientConnectionManager.closeIdleConnections(100L, TimeUnit.MILLISECONDS);
        SocketConfig socketConfig = SocketConfig.copy((SocketConfig)this.createSocketConfig()).setSoTimeout(socket_timeout > 0 ? socket_timeout : this.TIMEOUT_THREE_HOURS).build();
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)this.createRequestConfig()).setConnectTimeout(connection_timeout > 0 ? connection_timeout : 120000).setSocketTimeout(socket_timeout > 0 ? socket_timeout : this.TIMEOUT_THREE_HOURS).build();
        return HttpClientBuilder.create().setConnectionManager(this.gridClientConnectionManager).setRedirectStrategy((RedirectStrategy)new MyRedirectHandler()).setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).setRoutePlanner(this.createRoutePlanner()).build();
    }

    private SocketConfig createSocketConfig() {
        return SocketConfig.custom().setSoReuseAddress(true).setSoTimeout(this.TIMEOUT_THREE_HOURS).build();
    }

    private RequestConfig createRequestConfig() {
        return RequestConfig.custom().setStaleConnectionCheckEnabled(true).setConnectTimeout(120000).setSocketTimeout(this.TIMEOUT_THREE_HOURS).build();
    }

    private HttpRoutePlanner createRoutePlanner() {
        return new SystemDefaultRoutePlanner((SchemePortResolver)new DefaultSchemePortResolver(), ProxySelector.getDefault());
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gridClientConnectionManager.shutdown();
    }

    static class MyRedirectHandler
    implements RedirectStrategy {
        MyRedirectHandler() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }
}

