/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.CompositeAction;
import org.openqa.selenium.interactions.ContextClickAction;
import org.openqa.selenium.interactions.DoubleClickAction;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.MoveMouseAction;
import org.openqa.selenium.interactions.MoveToOffsetAction;
import org.openqa.selenium.interactions.SendKeysAction;
import org.openqa.selenium.internal.Locatable;

public class Actions {
    protected Mouse mouse;
    protected Keyboard keyboard;
    protected CompositeAction action;

    public Actions(WebDriver driver) {
        this(((HasInputDevices)((Object)driver)).getKeyboard(), ((HasInputDevices)((Object)driver)).getMouse());
    }

    public Actions(Keyboard keyboard, Mouse mouse) {
        this.mouse = mouse;
        this.keyboard = keyboard;
        this.resetCompositeAction();
    }

    public Actions(Keyboard keyboard) {
        this.keyboard = keyboard;
        this.resetCompositeAction();
    }

    private void resetCompositeAction() {
        this.action = new CompositeAction();
    }

    public Actions keyDown(Keys theKey) {
        return this.keyDown(null, theKey);
    }

    public Actions keyDown(WebElement element, Keys theKey) {
        this.action.addAction(new KeyDownAction(this.keyboard, this.mouse, (Locatable)((Object)element), theKey));
        return this;
    }

    public Actions keyUp(Keys theKey) {
        return this.keyUp(null, theKey);
    }

    public Actions keyUp(WebElement element, Keys theKey) {
        this.action.addAction(new KeyUpAction(this.keyboard, this.mouse, (Locatable)((Object)element), theKey));
        return this;
    }

    public Actions sendKeys(CharSequence ... keysToSend) {
        return this.sendKeys((WebElement)null, keysToSend);
    }

    public Actions sendKeys(WebElement element, CharSequence ... keysToSend) {
        this.action.addAction(new SendKeysAction(this.keyboard, this.mouse, (Locatable)((Object)element), keysToSend));
        return this;
    }

    public Actions clickAndHold(WebElement onElement) {
        this.action.addAction(new ClickAndHoldAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public Actions clickAndHold() {
        return this.clickAndHold(null);
    }

    public Actions release(WebElement onElement) {
        this.action.addAction(new ButtonReleaseAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public Actions release() {
        return this.release(null);
    }

    public Actions click(WebElement onElement) {
        this.action.addAction(new ClickAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public Actions click() {
        return this.click(null);
    }

    public Actions doubleClick(WebElement onElement) {
        this.action.addAction(new DoubleClickAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public Actions doubleClick() {
        return this.doubleClick(null);
    }

    public Actions moveToElement(WebElement toElement) {
        this.action.addAction(new MoveMouseAction(this.mouse, (Locatable)((Object)toElement)));
        return this;
    }

    public Actions moveToElement(WebElement toElement, int xOffset, int yOffset) {
        this.action.addAction(new MoveToOffsetAction(this.mouse, (Locatable)((Object)toElement), xOffset, yOffset));
        return this;
    }

    public Actions moveByOffset(int xOffset, int yOffset) {
        this.action.addAction(new MoveToOffsetAction(this.mouse, null, xOffset, yOffset));
        return this;
    }

    public Actions contextClick(WebElement onElement) {
        this.action.addAction(new ContextClickAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public Actions contextClick() {
        return this.contextClick(null);
    }

    public Actions dragAndDrop(WebElement source, WebElement target) {
        this.action.addAction(new ClickAndHoldAction(this.mouse, (Locatable)((Object)source)));
        this.action.addAction(new MoveMouseAction(this.mouse, (Locatable)((Object)target)));
        this.action.addAction(new ButtonReleaseAction(this.mouse, (Locatable)((Object)target)));
        return this;
    }

    public Actions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        this.action.addAction(new ClickAndHoldAction(this.mouse, (Locatable)((Object)source)));
        this.action.addAction(new MoveToOffsetAction(this.mouse, null, xOffset, yOffset));
        this.action.addAction(new ButtonReleaseAction(this.mouse, null));
        return this;
    }

    public Action build() {
        CompositeAction toReturn = this.action;
        this.resetCompositeAction();
        return toReturn;
    }

    public void perform() {
        this.build().perform();
    }
}

