/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import org.neo4j.driver.v1.exceptions.AuthenticationException;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.DatabaseException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.TransientException;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static ServiceUnavailableException newConnectionTerminatedError(String reason) {
        if (reason == null) {
            return ErrorUtil.newConnectionTerminatedError();
        }
        return new ServiceUnavailableException("Connection to the database terminated. " + reason);
    }

    public static ServiceUnavailableException newConnectionTerminatedError() {
        return new ServiceUnavailableException("Connection to the database terminated. This can happen due to network instabilities, or due to restarts of the database");
    }

    public static Neo4jException newNeo4jError(String code, String message) {
        String classification;
        switch (classification = ErrorUtil.extractClassification(code)) {
            case "ClientError": {
                if (code.equalsIgnoreCase("Neo.ClientError.Security.Unauthorized")) {
                    return new AuthenticationException(code, message);
                }
                return new ClientException(code, message);
            }
            case "TransientError": {
                return new TransientException(code, message);
            }
        }
        return new DatabaseException(code, message);
    }

    public static boolean isFatal(Throwable error) {
        if (error instanceof Neo4jException) {
            if (ErrorUtil.isProtocolViolationError((Neo4jException)error)) {
                return true;
            }
            if (ErrorUtil.isClientOrTransientError((Neo4jException)error)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isProtocolViolationError(Neo4jException error) {
        String errorCode = error.code();
        return errorCode != null && errorCode.startsWith("Neo.ClientError.Request");
    }

    private static boolean isClientOrTransientError(Neo4jException error) {
        String errorCode = error.code();
        return errorCode != null && (errorCode.contains("ClientError") || errorCode.contains("TransientError"));
    }

    private static String extractClassification(String code) {
        String[] parts = code.split("\\.");
        if (parts.length < 2) {
            return "";
        }
        return parts[1];
    }
}

