/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.handlers.RoutingResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Value;

public class RoutingConnection
implements Connection {
    private final Connection delegate;
    private final AccessMode accessMode;
    private final RoutingErrorHandler errorHandler;

    public RoutingConnection(Connection delegate, AccessMode accessMode, RoutingErrorHandler errorHandler) {
        this.delegate = delegate;
        this.accessMode = accessMode;
        this.errorHandler = errorHandler;
    }

    @Override
    public void enableAutoRead() {
        this.delegate.enableAutoRead();
    }

    @Override
    public void disableAutoRead() {
        this.delegate.disableAutoRead();
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        this.delegate.run(statement, parameters, this.newRoutingResponseHandler(runHandler), this.newRoutingResponseHandler(pullAllHandler));
    }

    @Override
    public void runAndFlush(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        this.delegate.runAndFlush(statement, parameters, this.newRoutingResponseHandler(runHandler), this.newRoutingResponseHandler(pullAllHandler));
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public CompletionStage<Void> release() {
        return this.delegate.release();
    }

    @Override
    public void terminateAndRelease(String reason) {
        this.delegate.terminateAndRelease(reason);
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    @Override
    public ServerVersion serverVersion() {
        return this.delegate.serverVersion();
    }

    private RoutingResponseHandler newRoutingResponseHandler(ResponseHandler handler) {
        return new RoutingResponseHandler(handler, this.serverAddress(), this.accessMode, this.errorHandler);
    }
}

