/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static final String lSep = System.getProperty("line.separator");
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public static String decodeName(String name) {
        int length = name.length();
        StringBuilder value = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            int end;
            int start = name.indexOf(95, i);
            if (start == -1) {
                value.append(name, i, length);
                break;
            }
            if (i != start) {
                value.append(name, i, start);
            }
            if ((end = start + 6) < length && name.charAt(start + 1) == 'x' && name.charAt(end) == '_' && DOMElementWriter.isHexDigit(name.charAt(start + 2)) && DOMElementWriter.isHexDigit(name.charAt(start + 3)) && DOMElementWriter.isHexDigit(name.charAt(start + 4)) && DOMElementWriter.isHexDigit(name.charAt(start + 5))) {
                char c = (char)Integer.parseInt(name.substring(start + 2, end), 16);
                if (start == 0 ? !DOMElementWriter.isNameStartChar(c) : !DOMElementWriter.isNameChar(c)) {
                    value.append(c);
                    i = end + 1;
                    continue;
                }
            }
            value.append(name.charAt(start));
            i = start + 1;
        }
        return value.toString();
    }

    public static String encodeName(String value) {
        int length = value.length();
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (i == 0) {
                if (DOMElementWriter.isNameStartChar(c)) {
                    name.append(c);
                    continue;
                }
            } else if (DOMElementWriter.isNameChar(c)) {
                name.append(c);
                continue;
            }
            name.append("_x");
            if (c <= '\u000f') {
                name.append("000");
            } else if (c <= '\u00ff') {
                name.append("00");
            } else if (c <= '\u0fff') {
                name.append('0');
            }
            name.append(Integer.toHexString(c).toUpperCase());
            name.append('_');
        }
        return name.toString();
    }

    private static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    private static boolean isNameChar(char c) {
        if (DOMElementWriter.isNameStartChar(c)) {
            return true;
        }
        if (c == '-' || c == '.') {
            return true;
        }
        if ('0' <= c && c <= '9') {
            return true;
        }
        if (c == '\u00b7') {
            return true;
        }
        if (c < '\u0300') {
            return false;
        }
        if (c <= '\u036f') {
            return true;
        }
        if (c < '\u203f') {
            return false;
        }
        return c <= '\u2040';
    }

    private static boolean isNameStartChar(char c) {
        if (c == ':' || c == '_') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if (c < '\u00c0') {
            return false;
        }
        if (c <= '\u00d6') {
            return true;
        }
        if (c < '\u00d8') {
            return false;
        }
        if (c <= '\u00f6') {
            return true;
        }
        if (c < '\u00f8') {
            return false;
        }
        if (c <= '\u02ff') {
            return true;
        }
        if (c < '\u0370') {
            return false;
        }
        if (c <= '\u037d') {
            return true;
        }
        if (c < '\u037f') {
            return false;
        }
        if (c <= '\u1fff') {
            return true;
        }
        if (c < '\u200c') {
            return false;
        }
        if (c <= '\u200d') {
            return true;
        }
        if (c < '\u2070') {
            return false;
        }
        if (c <= '\u218f') {
            return true;
        }
        if (c < '\u2c00') {
            return false;
        }
        if (c <= '\u2fef') {
            return true;
        }
        if (c < '\u3001') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\uf900') {
            return false;
        }
        if (c <= '\ufdcf') {
            return true;
        }
        if (c < '\ufdf0') {
            return false;
        }
        return c <= '\ufffd';
    }

    public void write(Element root, OutputStream out) throws IOException {
        OutputStreamWriter wri = new OutputStreamWriter(out, "UTF-8");
        wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lSep);
        this.write(root, wri, 0, "  ");
        ((Writer)wri).flush();
    }

    public void write(Node element, Writer out, int indent, String indentWith) throws IOException {
        int i;
        for (int i2 = 0; i2 < indent; ++i2) {
            out.write(indentWith);
        }
        if (element.getNodeType() == 8) {
            out.write("<!--");
            out.write(this.encode(element.getNodeValue()));
            out.write("-->");
        } else {
            out.write("<");
            out.write(((Element)element).getTagName());
            NamedNodeMap attrs = element.getAttributes();
            for (int i3 = 0; i3 < attrs.getLength(); ++i3) {
                Attr attr = (Attr)attrs.item(i3);
                out.write(" ");
                out.write(attr.getName());
                out.write("=\"");
                out.write(this.encode(attr.getValue()));
                out.write("\"");
            }
            out.write(">");
        }
        boolean hasChildren = false;
        NodeList children = element.getChildNodes();
        block9: for (i = 0; element.hasChildNodes() && i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: 
                case 8: {
                    if (!hasChildren) {
                        out.write(lSep);
                        hasChildren = true;
                    }
                    this.write(child, out, indent + 1, indentWith);
                    continue block9;
                }
                case 3: {
                    if (child.getNodeValue() == null || child.getNodeValue().indexOf("\n") != -1 && child.getNodeValue().trim().length() == 0) continue block9;
                    out.write(this.encode(child.getNodeValue()));
                    continue block9;
                }
                case 4: {
                    out.write("<![CDATA[");
                    out.write(this.encodedata(((Text)child).getData()));
                    out.write("]]>");
                    continue block9;
                }
                case 5: {
                    out.write(38);
                    out.write(child.getNodeName());
                    out.write(59);
                    continue block9;
                }
                case 7: {
                    out.write("<?");
                    out.write(child.getNodeName());
                    String data = child.getNodeValue();
                    if (data != null && data.length() > 0) {
                        out.write(32);
                        out.write(data);
                    }
                    out.write("?>");
                }
            }
        }
        if (hasChildren) {
            for (i = 0; i < indent; ++i) {
                out.write(indentWith);
            }
        }
        if (element.getNodeType() == 1) {
            out.write("</");
            out.write(((Element)element).getTagName());
            out.write(">");
        }
        out.write(lSep);
        out.flush();
    }

    public String encode(String value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !this.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    if (!this.isLegalCharacter(c)) continue block7;
                    sb.append(c);
                }
            }
        }
        return sb.substring(0);
    }

    public String encodedata(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (!this.isLegalCharacter(c)) continue;
            sb.append(c);
        }
        String result = sb.substring(0);
        int cdEnd = result.indexOf("]]>");
        while (cdEnd != -1) {
            sb.setLength(cdEnd);
            sb.append("&#x5d;&#x5d;&gt;").append(result.substring(cdEnd + 3));
            result = sb.substring(0);
            cdEnd = result.indexOf("]]>");
        }
        return result;
    }

    public boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        for (int i = 0; i < this.knownEntities.length; ++i) {
            if (!name.equals(this.knownEntities[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }
}

