/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.List;
import org.jitsi.impl.neomedia.transform.fec.FlexFec03Header;
import org.jitsi.impl.neomedia.transform.fec.FlexFec03HeaderReader;
import org.jitsi.service.neomedia.RawPacket;

public class FlexFec03Packet
extends RawPacket {
    protected FlexFec03Header header;

    public static FlexFec03Packet create(RawPacket p) {
        return FlexFec03Packet.create(p.getBuffer(), p.getOffset(), p.getLength());
    }

    public static FlexFec03Packet create(byte[] buffer, int offset, int length) {
        FlexFec03Packet flexFecPacket = new FlexFec03Packet(buffer, offset, length);
        FlexFec03Header header = FlexFec03HeaderReader.readFlexFecHeader(flexFecPacket.getBuffer(), flexFecPacket.getFlexFecHeaderOffset(), flexFecPacket.getLength() - flexFecPacket.getHeaderLength());
        if (header == null) {
            return null;
        }
        flexFecPacket.header = header;
        return flexFecPacket;
    }

    private FlexFec03Packet(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public List<Integer> getProtectedSequenceNumbers() {
        return this.header.protectedSeqNums;
    }

    public int getFlexFecHeaderSize() {
        return this.header.size;
    }

    public long getProtectedSsrc() {
        return this.header.protectedSsrc;
    }

    public int getFlexFecPayloadLength() {
        return this.getLength() - this.getHeaderLength() - this.header.size;
    }

    public int getFlexFecHeaderOffset() {
        return this.getOffset() + this.getHeaderLength();
    }
}

