/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.SortedMap;
import java.util.TreeMap;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.Logger;

public abstract class AbstractFECReceiver
implements PacketTransformer {
    private static final Logger logger = Logger.getLogger(AbstractFECReceiver.class);
    protected final Statistics statistics = new Statistics();
    protected long ssrc;
    protected boolean handleFec = true;
    private static final int MEDIA_BUF_SIZE;
    private static final int FEC_BUF_SIZE;
    private static final String MEDIA_BUF_SIZE_PNAME;
    private static final String FEC_BUF_SIZE_PNAME;
    private byte payloadType;
    protected final SortedMap<Integer, RawPacket> mediaPackets = new TreeMap<Integer, RawPacket>(RTPUtils.sequenceNumberComparator);
    protected final SortedMap<Integer, RawPacket> fecPackets = new TreeMap<Integer, RawPacket>(RTPUtils.sequenceNumberComparator);

    AbstractFECReceiver(long ssrc, byte payloadType) {
        this.ssrc = ssrc;
        this.payloadType = payloadType;
    }

    private void saveFec(RawPacket p) {
        if (this.fecPackets.size() >= FEC_BUF_SIZE) {
            this.fecPackets.remove(this.fecPackets.firstKey());
        }
        this.fecPackets.put(p.getSequenceNumber(), p);
    }

    protected void saveMedia(RawPacket p) {
        RawPacket newMedia;
        if (this.mediaPackets.size() < MEDIA_BUF_SIZE) {
            newMedia = new RawPacket();
            newMedia.setBuffer(new byte[1500]);
            newMedia.setOffset(0);
        } else {
            newMedia = (RawPacket)this.mediaPackets.remove(this.mediaPackets.firstKey());
        }
        int pLen = p.getLength();
        if (pLen > newMedia.getBuffer().length) {
            newMedia.setBuffer(new byte[pLen]);
        }
        System.arraycopy(p.getBuffer(), p.getOffset(), newMedia.getBuffer(), 0, pLen);
        newMedia.setLength(pLen);
        newMedia.setOffset(0);
        this.mediaPackets.put(newMedia.getSequenceNumber(), newMedia);
    }

    public void setPayloadType(byte payloadType) {
        this.payloadType = payloadType;
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return pkts;
    }

    @Override
    public synchronized RawPacket[] reverseTransform(RawPacket[] pkts) {
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            if (pkt == null) continue;
            if (pkt.getPayloadType() == this.payloadType) {
                pkts[i] = null;
                ++this.statistics.numRxFecPackets;
                if (!this.handleFec) continue;
                this.saveFec(pkt);
                continue;
            }
            if (!this.handleFec) continue;
            this.saveMedia(pkt);
        }
        pkts = this.doReverseTransform(pkts);
        return pkts;
    }

    @Override
    public void close() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Closing AbstractFECReceiver for SSRC=" + this.ssrc + ". Received " + this.statistics.numRxFecPackets + " fec packets, recovered " + this.statistics.numRecoveredPackets + " media packets. Recovery failed " + this.statistics.failedRecoveries + " times"));
        }
    }

    protected abstract RawPacket[] doReverseTransform(RawPacket[] var1);

    static {
        MEDIA_BUF_SIZE_PNAME = AbstractFECReceiver.class.getName() + ".MEDIA_BUFF_SIZE";
        FEC_BUF_SIZE_PNAME = AbstractFECReceiver.class.getName() + ".FEC_BUFF_SIZE";
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        int fecBufSize = 32;
        int mediaBufSize = 64;
        if (cfg != null) {
            fecBufSize = cfg.getInt(FEC_BUF_SIZE_PNAME, fecBufSize);
            mediaBufSize = cfg.getInt(MEDIA_BUF_SIZE_PNAME, mediaBufSize);
        }
        FEC_BUF_SIZE = fecBufSize;
        MEDIA_BUF_SIZE = mediaBufSize;
    }

    class Statistics {
        int numRxFecPackets;
        int numRecoveredPackets;
        int failedRecoveries;

        Statistics() {
        }
    }
}

