/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.delay;

import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;

public class DelayingTransformEngine
implements TransformEngine {
    private DelayingTransformer delayingTransformer;

    public DelayingTransformEngine(int packetCount) {
        this.delayingTransformer = new DelayingTransformer(packetCount);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.delayingTransformer;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private class DelayingTransformer
    extends SinglePacketTransformer {
        private RawPacket[] buffer;
        private int idx = 0;

        DelayingTransformer(int pktCount) {
            this.buffer = new RawPacket[pktCount];
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            if (pkt != null) {
                RawPacket ret = this.buffer[this.idx];
                this.buffer[this.idx] = pkt;
                this.idx = (this.idx + 1) % this.buffer.length;
                return ret;
            }
            return null;
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            return pkt;
        }
    }
}

