/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.sendsidebandwidthestimation;

import java.util.Deque;
import java.util.IntSummaryStatistics;
import java.util.LinkedList;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Random;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtp.RTCPPacketListenerAdapter;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.rtp.BandwidthEstimator;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.logging.TimeSeriesLogger;

class SendSideBandwidthEstimation
extends RTCPPacketListenerAdapter
implements BandwidthEstimator {
    public static final String LOW_LOSS_THRESHOLD_PNAME = SendSideBandwidthEstimation.class.getName() + ".lowLossThreshold";
    public static final String HIGH_LOSS_THRESHOLD_PNAME = SendSideBandwidthEstimation.class.getName() + ".highLossThreshold";
    public static final String BITRATE_THRESHOLD_KBPS_PNAME = SendSideBandwidthEstimation.class.getName() + ".bitrateThresholdKbps";
    public static final String LOSS_EXPERIMENT_PROBABILITY_PNAME = SendSideBandwidthEstimation.class.getName() + ".lossExperimentProbability";
    public static final String TIMEOUT_EXPERIMENT_PROBABILITY_PNAME = SendSideBandwidthEstimation.class.getName() + ".timeoutExperimentProbability";
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    private static final int kBweIncreaseIntervalMs = 1000;
    private static final long kBweDecreaseIntervalMs = 300L;
    private static final int kDefaultMinBitrateBps = 10000;
    private static final int kDefaultMaxBitrateBps = 1000000000;
    private static final int kStartPhaseMs = 2000;
    private static final int kLimitNumPackets = 20;
    private static final long kFeedbackIntervalMs = 1500L;
    private static final double kPacketReportTimeoutIntervals = 1.2;
    private static final long kFeedbackTimeoutIntervals = 3L;
    private static final long kTimeoutIntervalMs = 1000L;
    private static final float kDefaultLowLossThreshold = 0.02f;
    private static final float kDefaultHighLossThreshold = 0.1f;
    private static final int kDefaultBitrateThresholdKbps = 0;
    private static final float kDefaultLossExperimentProbability = 0.0f;
    private static final float kDefaultTimeoutExperimentProbability = 0.0f;
    private static final Random kRandom = new Random();
    private static final Logger logger = Logger.getLogger(SendSideBandwidthEstimation.class);
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(SendSideBandwidthEstimation.class);
    private final float low_loss_threshold_;
    private final float high_loss_threshold_;
    private final int bitrate_threshold_bps_;
    private long first_report_time_ms_ = -1L;
    private int lost_packets_since_last_loss_update_Q8_ = 0;
    private int expected_packets_since_last_loss_update_ = 0;
    private boolean has_decreased_since_last_fraction_loss_ = false;
    private int last_fraction_loss_ = 0;
    private long last_feedback_ms_ = -1L;
    private long last_packet_report_ms_ = -1L;
    private long last_timeout_ms_ = -1L;
    private final boolean in_timeout_experiment_;
    private int min_bitrate_configured_ = 10000;
    private int max_bitrate_configured_ = 1000000000;
    private long time_last_decrease_ms_ = 0L;
    private long bwe_incoming_ = 0L;
    private long bitrate_;
    private Deque<Pair<Long>> min_bitrate_history_ = new LinkedList<Pair<Long>>();
    private final DiagnosticContext diagnosticContext;
    private final List<BandwidthEstimator.Listener> listeners = new LinkedList<BandwidthEstimator.Listener>();
    private final MediaStream mediaStream;
    private final StatisticsImpl statistics = new StatisticsImpl();

    SendSideBandwidthEstimation(MediaStreamImpl stream, long startBitrate) {
        this.mediaStream = stream;
        this.diagnosticContext = stream.getDiagnosticContext();
        float lossExperimentProbability = (float)cfg.getDouble(LOSS_EXPERIMENT_PROBABILITY_PNAME, 0.0);
        if (kRandom.nextFloat() < lossExperimentProbability) {
            this.low_loss_threshold_ = (float)cfg.getDouble(LOW_LOSS_THRESHOLD_PNAME, 0.02f);
            this.high_loss_threshold_ = (float)cfg.getDouble(HIGH_LOSS_THRESHOLD_PNAME, 0.1f);
            this.bitrate_threshold_bps_ = 1000 * cfg.getInt(BITRATE_THRESHOLD_KBPS_PNAME, 0);
        } else {
            this.low_loss_threshold_ = 0.02f;
            this.high_loss_threshold_ = 0.1f;
            this.bitrate_threshold_bps_ = 0;
        }
        float timeoutExperimentProbability = (float)cfg.getDouble(TIMEOUT_EXPERIMENT_PROBABILITY_PNAME, 0.0);
        this.in_timeout_experiment_ = kRandom.nextFloat() < timeoutExperimentProbability;
        this.setBitrate(startBitrate);
    }

    private synchronized boolean isInStartPhase(long now) {
        return this.first_report_time_ms_ == -1L || now - this.first_report_time_ms_ < 2000L;
    }

    private synchronized long capBitrateToThresholds(long bitrate) {
        if (this.bwe_incoming_ > 0L && bitrate > this.bwe_incoming_) {
            bitrate = this.bwe_incoming_;
        }
        if (bitrate > (long)this.max_bitrate_configured_) {
            bitrate = this.max_bitrate_configured_;
        }
        if (bitrate < (long)this.min_bitrate_configured_) {
            bitrate = this.min_bitrate_configured_;
        }
        return bitrate;
    }

    protected synchronized void updateEstimate(long now) {
        long bitrate = this.bitrate_;
        if (this.last_fraction_loss_ == 0 && this.isInStartPhase(now) && this.bwe_incoming_ > bitrate) {
            this.setBitrate(this.capBitrateToThresholds(this.bwe_incoming_));
            this.min_bitrate_history_.clear();
            this.min_bitrate_history_.addLast(new Pair<Long>(now, this.bitrate_));
            return;
        }
        this.updateMinHistory(now);
        if (this.last_packet_report_ms_ == -1L) {
            this.bitrate_ = this.capBitrateToThresholds(this.bitrate_);
            return;
        }
        long time_since_packet_report_ms = now - this.last_packet_report_ms_;
        long time_since_feedback_ms = now - this.last_feedback_ms_;
        if ((double)time_since_packet_report_ms < 1800.0) {
            float loss = (float)this.last_fraction_loss_ / 256.0f;
            if (this.bitrate_ < (long)this.bitrate_threshold_bps_ || loss <= this.low_loss_threshold_) {
                bitrate = (long)((double)((Long)this.min_bitrate_history_.getFirst().second).longValue() * 1.08 + 0.5);
                bitrate += 1000L;
                this.statistics.update(now, false, LossRegion.LossFree);
            } else if (this.bitrate_ > (long)this.bitrate_threshold_bps_) {
                if (loss <= this.high_loss_threshold_) {
                    this.statistics.update(now, false, LossRegion.LossLimited);
                } else if (!this.has_decreased_since_last_fraction_loss_ && now - this.time_last_decrease_ms_ >= 300L + this.getRtt()) {
                    this.time_last_decrease_ms_ = now;
                    bitrate = (long)((double)(bitrate * (long)(512 - this.last_fraction_loss_)) / 512.0);
                    this.has_decreased_since_last_fraction_loss_ = true;
                    this.statistics.update(now, false, LossRegion.LossDegraded);
                }
            }
        } else {
            this.statistics.update(now, true, null);
            if (time_since_feedback_ms > 4500L && (this.last_timeout_ms_ == -1L || now - this.last_timeout_ms_ > 1000L) && this.in_timeout_experiment_) {
                this.bitrate_ = (long)((double)this.bitrate_ * 0.8);
                this.lost_packets_since_last_loss_update_Q8_ = 0;
                this.expected_packets_since_last_loss_update_ = 0;
                this.last_timeout_ms_ = now;
            }
        }
        this.setBitrate(this.capBitrateToThresholds(bitrate));
    }

    synchronized void updateReceiverBlock(long fraction_lost, long number_of_packets, long now) {
        this.last_feedback_ms_ = now;
        if (this.first_report_time_ms_ == -1L) {
            this.first_report_time_ms_ = now;
        }
        if (number_of_packets > 0L) {
            long num_lost_packets_Q8 = fraction_lost * number_of_packets;
            this.lost_packets_since_last_loss_update_Q8_ = (int)((long)this.lost_packets_since_last_loss_update_Q8_ + num_lost_packets_Q8);
            this.expected_packets_since_last_loss_update_ = (int)((long)this.expected_packets_since_last_loss_update_ + number_of_packets);
            if (this.expected_packets_since_last_loss_update_ < 20) {
                return;
            }
            this.has_decreased_since_last_fraction_loss_ = false;
            this.last_fraction_loss_ = this.lost_packets_since_last_loss_update_Q8_ / this.expected_packets_since_last_loss_update_;
            this.lost_packets_since_last_loss_update_Q8_ = 0;
            this.expected_packets_since_last_loss_update_ = 0;
            this.last_packet_report_ms_ = now;
            this.updateEstimate(now);
        }
    }

    private synchronized void updateMinHistory(long now_ms) {
        while (!this.min_bitrate_history_.isEmpty() && now_ms - (Long)this.min_bitrate_history_.getFirst().first + 1L > 1000L) {
            this.min_bitrate_history_.removeFirst();
        }
        while (!this.min_bitrate_history_.isEmpty() && this.bitrate_ <= (Long)this.min_bitrate_history_.getLast().second) {
            this.min_bitrate_history_.removeLast();
        }
        this.min_bitrate_history_.addLast(new Pair<Long>(now_ms, this.bitrate_));
    }

    @Override
    public synchronized void updateReceiverEstimate(long bandwidth) {
        this.bwe_incoming_ = bandwidth;
        this.setBitrate(this.capBitrateToThresholds(this.bitrate_));
    }

    synchronized void setMinMaxBitrate(int min_bitrate, int max_bitrate) {
        this.min_bitrate_configured_ = Math.max(min_bitrate, 10000);
        this.max_bitrate_configured_ = max_bitrate > 0 ? Math.max(this.min_bitrate_configured_, max_bitrate) : 1000000000;
    }

    private synchronized void setBitrate(long newValue) {
        long oldValue = this.bitrate_;
        this.bitrate_ = newValue;
        if (oldValue != this.bitrate_) {
            this.fireBandwidthEstimationChanged(oldValue, newValue);
        }
    }

    @Override
    public long getLatestEstimate() {
        return this.bitrate_;
    }

    @Override
    public long getLatestREMB() {
        return this.bwe_incoming_;
    }

    @Override
    public int getLatestFractionLoss() {
        return this.last_fraction_loss_;
    }

    @Override
    public synchronized void addListener(BandwidthEstimator.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(BandwidthEstimator.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void rembReceived(RTCPREMBPacket remb) {
        this.updateReceiverEstimate(remb.getBitrate());
    }

    @Override
    public StatisticsImpl getStatistics() {
        return this.statistics;
    }

    private synchronized long getRtt() {
        long rtt = this.mediaStream.getMediaStreamStats().getSendStats().getRtt();
        if (rtt < 0L || rtt > 1000L) {
            logger.warn((Object)("RTT not calculated, or has a suspiciously high value (" + rtt + "). Using the default of 100ms."));
            rtt = 100L;
        }
        return rtt;
    }

    private synchronized void fireBandwidthEstimationChanged(long oldValue, long newValue) {
        for (BandwidthEstimator.Listener listener : this.listeners) {
            listener.bandwidthEstimationChanged(newValue);
        }
    }

    private static enum LossRegion {
        LossLimited,
        LossDegraded,
        LossFree;

    }

    public class StatisticsImpl
    implements BandwidthEstimator.Statistics {
        private LossRegion currentState = null;
        private long lastTransitionTimestampMs = -1L;
        private long currentStateCumulativeDurationMs;
        private int currentStateConsecutiveVisits;
        private long currentStateStartBitrateBps;
        private LongSummaryStatistics currentStateBitrateStatistics = new LongSummaryStatistics();
        private IntSummaryStatistics currentStateLossStatistics = new IntSummaryStatistics();
        private boolean isDirty = false;
        private final LongSummaryStatistics lossFreeMsStats = new LongSummaryStatistics();
        private final LongSummaryStatistics lossDegradedMsStats = new LongSummaryStatistics();
        private final LongSummaryStatistics lossLimitedMsStats = new LongSummaryStatistics();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(long nowMs) {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                long time_since_packet_report_ms = nowMs - SendSideBandwidthEstimation.this.last_packet_report_ms_;
                boolean currentStateHasTimedOut = (double)time_since_packet_report_ms < 1800.0;
                this.update(nowMs, currentStateHasTimedOut, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(long nowMs, boolean currentStateHasTimedOut, LossRegion nextState) {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                if (this.lastTransitionTimestampMs > -1L && !currentStateHasTimedOut) {
                    this.isDirty = true;
                    this.currentStateCumulativeDurationMs += nowMs - this.lastTransitionTimestampMs;
                }
                this.lastTransitionTimestampMs = nowMs;
                if (!currentStateHasTimedOut) {
                    this.isDirty = true;
                    this.currentStateLossStatistics.accept(SendSideBandwidthEstimation.this.last_fraction_loss_);
                    ++this.currentStateConsecutiveVisits;
                    if (this.currentState == nextState) {
                        this.currentStateBitrateStatistics.accept(SendSideBandwidthEstimation.this.bitrate_);
                        return;
                    }
                }
                if (this.currentState != null) {
                    switch (this.currentState) {
                        case LossDegraded: {
                            this.lossDegradedMsStats.accept(this.currentStateCumulativeDurationMs);
                            break;
                        }
                        case LossFree: {
                            this.lossFreeMsStats.accept(this.currentStateCumulativeDurationMs);
                            break;
                        }
                        case LossLimited: {
                            this.lossLimitedMsStats.accept(this.currentStateCumulativeDurationMs);
                        }
                    }
                    if (timeSeriesLogger.isTraceEnabled()) {
                        timeSeriesLogger.trace((Map)SendSideBandwidthEstimation.this.diagnosticContext.makeTimeSeriesPoint("loss_estimate").addField("state", (Object)this.currentState.name()).addField("max_loss", (Object)Float.valueOf((float)this.currentStateLossStatistics.getMax() / 256.0f)).addField("min_loss", (Object)Float.valueOf((float)this.currentStateLossStatistics.getMin() / 256.0f)).addField("avg_loss", (Object)(this.currentStateLossStatistics.getAverage() / 256.0)).addField("max_bps", (Object)this.currentStateBitrateStatistics.getMax()).addField("min_bps", (Object)this.currentStateBitrateStatistics.getMin()).addField("avg_bps", (Object)this.currentStateBitrateStatistics.getAverage()).addField("duration_ms", (Object)this.currentStateCumulativeDurationMs).addField("consecutive_visits", (Object)this.currentStateConsecutiveVisits).addField("bitrate_threshold", (Object)SendSideBandwidthEstimation.this.bitrate_threshold_bps_).addField("low_loss_threshold", (Object)Float.valueOf(SendSideBandwidthEstimation.this.low_loss_threshold_)).addField("high_loss_threshold", (Object)Float.valueOf(SendSideBandwidthEstimation.this.high_loss_threshold_)).addField("delta_bps", (Object)(SendSideBandwidthEstimation.this.bitrate_ - this.currentStateStartBitrateBps)));
                    }
                }
                this.currentState = nextState;
                this.currentStateStartBitrateBps = SendSideBandwidthEstimation.this.bitrate_;
                if (this.isDirty) {
                    this.currentStateLossStatistics = new IntSummaryStatistics();
                    this.currentStateBitrateStatistics = new LongSummaryStatistics();
                    this.currentStateConsecutiveVisits = 0;
                    this.currentStateCumulativeDurationMs = 0L;
                    this.isDirty = false;
                }
                this.currentStateBitrateStatistics.accept(SendSideBandwidthEstimation.this.bitrate_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLossLimitedMs() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                return this.lossLimitedMsStats.getSum();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLossDegradedMs() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                return this.lossDegradedMsStats.getSum();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLossFreeMs() {
            SendSideBandwidthEstimation sendSideBandwidthEstimation = SendSideBandwidthEstimation.this;
            synchronized (sendSideBandwidthEstimation) {
                return this.lossFreeMsStats.getSum();
            }
        }
    }

    private class Pair<T> {
        T first;
        T second;

        Pair(T a, T b) {
            this.first = a;
            this.second = b;
        }
    }
}

