/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateEstimatorAbsSendTime;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateEstimatorSingleStream;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateObserver;
import org.jitsi.impl.neomedia.transform.AbsSendTimeEngine;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.utils.logging.DiagnosticContext;

public class RemoteBitrateEstimatorWrapper
extends SinglePacketTransformerAdapter
implements RemoteBitrateEstimator,
TransformEngine {
    private static final long SS_THRESHOLD = 30L;
    private final RemoteBitrateObserver observer;
    private int minBitrateBps = -1;
    private int astExtensionID = -1;
    private int tccExtensionID = -1;
    private boolean supportsRemb = false;
    private boolean usingAbsoluteSendTime = false;
    private int packetsSinceAbsoluteSendTime = 0;
    private RemoteBitrateEstimator rbe;
    private final DiagnosticContext diagnosticContext;

    public RemoteBitrateEstimatorWrapper(RemoteBitrateObserver observer, @NotNull DiagnosticContext diagnosticContext) {
        this.observer = observer;
        this.diagnosticContext = diagnosticContext;
        this.rbe = new RemoteBitrateEstimatorSingleStream(observer, diagnosticContext);
    }

    @Override
    public long getLatestEstimate() {
        return this.rbe.getLatestEstimate();
    }

    @Override
    public Collection<Long> getSsrcs() {
        return this.rbe.getSsrcs();
    }

    @Override
    public void removeStream(long ssrc) {
        this.rbe.removeStream(ssrc);
    }

    @Override
    public void setMinBitrate(int minBitrateBps) {
        this.minBitrateBps = minBitrateBps;
        this.rbe.setMinBitrate(minBitrateBps);
    }

    @Override
    public void incomingPacketInfo(long arrivalTimeMs, long timestamp, int payloadSize, long ssrc) {
        this.rbe.incomingPacketInfo(arrivalTimeMs, timestamp, payloadSize, ssrc);
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        long sendTime24bits;
        int minBitrateBps;
        if (!this.receiveSideBweEnabled()) {
            return pkt;
        }
        RawPacket.HeaderExtension ext = null;
        int astExtensionID = this.astExtensionID;
        if (astExtensionID != -1) {
            ext = pkt.getHeaderExtension((byte)astExtensionID);
        }
        if (ext != null) {
            if (!this.usingAbsoluteSendTime) {
                this.usingAbsoluteSendTime = true;
                this.rbe = new RemoteBitrateEstimatorAbsSendTime(this.observer, this.diagnosticContext);
                minBitrateBps = this.minBitrateBps;
                if (minBitrateBps > 0) {
                    this.rbe.setMinBitrate(minBitrateBps);
                }
            }
            this.packetsSinceAbsoluteSendTime = 0;
        } else if (this.usingAbsoluteSendTime) {
            ++this.packetsSinceAbsoluteSendTime;
            if ((long)this.packetsSinceAbsoluteSendTime >= 30L) {
                this.usingAbsoluteSendTime = false;
                this.rbe = new RemoteBitrateEstimatorSingleStream(this.observer, this.diagnosticContext);
                minBitrateBps = this.minBitrateBps;
                if (minBitrateBps > 0) {
                    this.rbe.setMinBitrate(minBitrateBps);
                }
            }
        }
        if (!this.usingAbsoluteSendTime) {
            this.incomingPacketInfo(System.currentTimeMillis(), pkt.getTimestamp(), pkt.getPayloadLength(), pkt.getSSRCAsLong());
            return pkt;
        }
        long l = sendTime24bits = astExtensionID == -1 ? -1L : AbsSendTimeEngine.getAbsSendTime(pkt, (byte)astExtensionID);
        if (this.usingAbsoluteSendTime && sendTime24bits != -1L) {
            this.incomingPacketInfo(System.currentTimeMillis(), sendTime24bits, pkt.getPayloadLength(), pkt.getSSRCAsLong());
        }
        return pkt;
    }

    @Override
    public void onRttUpdate(long avgRttMs, long maxRttMs) {
        this.rbe.onRttUpdate(avgRttMs, maxRttMs);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    public void setAstExtensionID(int astExtensionID) {
        this.astExtensionID = astExtensionID;
    }

    public boolean receiveSideBweEnabled() {
        return this.tccExtensionID == -1 && this.supportsRemb;
    }

    public void setSupportsRemb(boolean supportsRemb) {
        this.supportsRemb = supportsRemb;
    }

    public void setTccExtensionID(int tccExtensionID) {
        this.tccExtensionID = tccExtensionID;
    }
}

