/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.util.LinkedList;
import java.util.List;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.AudioSystem2;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.CoreAudioDevice;
import org.jitsi.impl.neomedia.device.MacCoreAudioDevice;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.MacCoreaudioRenderer;
import org.jitsi.utils.logging.Logger;

public class MacCoreaudioSystem
extends AudioSystem2 {
    private static final String LOCATOR_PROTOCOL = "maccoreaudio";
    private static final Logger logger = Logger.getLogger(MacCoreaudioSystem.class);
    private Runnable devicesChangedCallback;

    private static double getSupportedSampleRate(boolean input, String deviceUID, boolean isEchoCancel) {
        double supportedSampleRate = MacCoreAudioDevice.getNominalSampleRate(deviceUID, false, isEchoCancel);
        if (supportedSampleRate >= MediaUtils.MAX_AUDIO_SAMPLE_RATE) {
            supportedSampleRate = 44100.0;
        }
        return supportedSampleRate;
    }

    MacCoreaudioSystem() throws Exception {
        super(LOCATOR_PROTOCOL, 13);
    }

    @Override
    protected void doInitialize() throws Exception {
        int i;
        if (!CoreAudioDevice.isLoaded) {
            String message = "MacOSX CoreAudio library is not loaded";
            if (logger.isInfoEnabled()) {
                logger.info((Object)message);
            }
            throw new Exception(message);
        }
        if (this.devicesChangedCallback == null) {
            CoreAudioDevice.initDevices();
        }
        int channels = 1;
        int sampleSizeInBits = 16;
        String defaultInputdeviceUID = MacCoreAudioDevice.getDefaultInputDeviceUID();
        String defaultOutputdeviceUID = MacCoreAudioDevice.getDefaultOutputDeviceUID();
        LinkedList<CaptureDeviceInfo2> captureAndPlaybackDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> captureDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevices = new LinkedList<CaptureDeviceInfo2>();
        boolean loggerIsDebugEnabled = logger.isDebugEnabled();
        String[] deviceUIDList = MacCoreAudioDevice.getDeviceUIDList();
        for (i = 0; i < deviceUIDList.length; ++i) {
            String deviceUID = deviceUIDList[i];
            String name = CoreAudioDevice.getDeviceName(deviceUID);
            boolean isInputDevice = MacCoreAudioDevice.isInputDevice(deviceUID);
            boolean isOutputDevice = MacCoreAudioDevice.isOutputDevice(deviceUID);
            String transportType = MacCoreAudioDevice.getTransportType(deviceUID);
            String modelIdentifier = null;
            String locatorRemainder = name;
            if (deviceUID != null) {
                modelIdentifier = CoreAudioDevice.getDeviceModelIdentifier(deviceUID);
                locatorRemainder = deviceUID;
            }
            List<CaptureDeviceInfo2> existingCdis = this.getDevices(AudioSystem.DataFlow.CAPTURE);
            CaptureDeviceInfo2 cdi = null;
            if (existingCdis != null) {
                for (CaptureDeviceInfo2 existingCdi : existingCdis) {
                    double rate;
                    String id = existingCdi.getIdentifier();
                    if (!id.equals(deviceUID) && !id.equals(name) || (rate = ((AudioFormat)existingCdi.getFormats()[0]).getSampleRate()) != MacCoreaudioSystem.getSupportedSampleRate(true, deviceUID, this.isEchoCancel())) continue;
                    cdi = existingCdi;
                    break;
                }
            }
            if (cdi == null) {
                cdi = new CaptureDeviceInfo2(name, new MediaLocator("maccoreaudio:#" + locatorRemainder), new Format[]{new AudioFormat("LINEAR", isInputDevice ? MacCoreaudioSystem.getSupportedSampleRate(true, deviceUID, this.isEchoCancel()) : 44100.0, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray)}, deviceUID, transportType, modelIdentifier);
            }
            boolean isDefaultInputDevice = deviceUID.equals(defaultInputdeviceUID);
            boolean isDefaultOutputDevice = deviceUID.equals(defaultOutputdeviceUID);
            if (isInputDevice) {
                LinkedList<CaptureDeviceInfo2> devices = isOutputDevice ? captureAndPlaybackDevices : captureDevices;
                if (isDefaultInputDevice || isOutputDevice && isDefaultOutputDevice) {
                    devices.add(0, cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug((Object)("Added default capture device: " + name));
                    }
                } else {
                    devices.add(cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug((Object)("Added capture device: " + name));
                    }
                }
                if (!loggerIsDebugEnabled || !isInputDevice) continue;
                if (isDefaultOutputDevice) {
                    logger.debug((Object)("Added default playback device: " + name));
                    continue;
                }
                logger.debug((Object)("Added playback device: " + name));
                continue;
            }
            if (!isOutputDevice) continue;
            if (isDefaultOutputDevice) {
                playbackDevices.add(0, cdi);
                if (!loggerIsDebugEnabled) continue;
                logger.debug((Object)("Added default playback device: " + name));
                continue;
            }
            playbackDevices.add(cdi);
            if (!loggerIsDebugEnabled) continue;
            logger.debug((Object)("Added playback device: " + name));
        }
        MacCoreaudioSystem.bubbleUpUsbDevices(captureDevices);
        MacCoreaudioSystem.bubbleUpUsbDevices(playbackDevices);
        if (!captureDevices.isEmpty() && !playbackDevices.isEmpty()) {
            MacCoreaudioSystem.matchDevicesByName(captureDevices, playbackDevices);
        }
        if (!captureAndPlaybackDevices.isEmpty()) {
            MacCoreaudioSystem.bubbleUpUsbDevices(captureAndPlaybackDevices);
            for (i = captureAndPlaybackDevices.size() - 1; i >= 0; --i) {
                CaptureDeviceInfo2 cdi = (CaptureDeviceInfo2)((Object)captureAndPlaybackDevices.get(i));
                captureDevices.add(0, cdi);
                playbackDevices.add(0, cdi);
            }
        }
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
        if (this.devicesChangedCallback == null) {
            this.devicesChangedCallback = new Runnable(){

                @Override
                public void run() {
                    try {
                        MacCoreaudioSystem.this.reinitialize();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn((Object)"Failed to reinitialize MacCoreaudio devices", t);
                    }
                }
            };
            CoreAudioDevice.setDevicesChangedCallback(this.devicesChangedCallback);
        }
    }

    @Override
    protected String getRendererClassName() {
        return MacCoreaudioRenderer.class.getName();
    }

    @Override
    public void setEchoCancel(boolean echoCancel) {
        super.setEchoCancel(echoCancel);
        try {
            this.reinitialize();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to reinitialize MacCoreaudio devices", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "Core Audio";
    }

    @Override
    protected void updateAvailableDeviceList() {
    }
}

