/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h264;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import net.iharder.Base64;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.h264.H264;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.utils.logging.Logger;

public class JNIDecoder
extends AbstractCodec {
    private static final VideoFormat[] DEFAULT_OUTPUT_FORMATS = new VideoFormat[]{new AVFrameFormat(0)};
    private static final Logger logger = Logger.getLogger(JNIDecoder.class);
    private static final String PLUGIN_NAME = "H.264 Decoder";
    private long avctx;
    private AVFrame avframe;
    private final boolean[] got_picture = new boolean[1];
    private boolean gotPictureAtLeastOnce;
    private int height;
    private KeyFrameControl keyFrameControl;
    private final VideoFormat[] outputFormats;
    private int width;

    public JNIDecoder() {
        this.inputFormats = new VideoFormat[]{new ParameterizedVideoFormat("h264", new String[0]), new VideoFormat("h264")};
        this.outputFormats = DEFAULT_OUTPUT_FORMATS;
    }

    public boolean checkFormat(Format format) {
        return format.getEncoding().equals("h264/rtp");
    }

    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            FFmpeg.avcodec_close((long)this.avctx);
            FFmpeg.av_free((long)this.avctx);
            this.avctx = 0L;
            if (this.avframe != null) {
                this.avframe.free();
                this.avframe = null;
            }
            this.gotPictureAtLeastOnce = false;
        }
    }

    private float ensureFrameRate(float frameRate) {
        return frameRate;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        return new Format[]{new AVFrameFormat(inputVideoFormat.getSize(), this.ensureFrameRate(inputVideoFormat.getFrameRate()), 0)};
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format inputFormat) {
        Object[] supportedOutputFormats = inputFormat == null ? this.outputFormats : (!(inputFormat instanceof VideoFormat) || AbstractCodec2.matches(inputFormat, this.inputFormats) == null ? AbstractCodec2.EMPTY_FORMATS : this.getMatchingOutputFormats(inputFormat));
        return supportedOutputFormats;
    }

    private void handleFmtps() {
        try {
            ParameterizedVideoFormat pvf;
            String spropParameterSets;
            Format f = this.getInputFormat();
            if (f instanceof ParameterizedVideoFormat && (spropParameterSets = (pvf = (ParameterizedVideoFormat)f).getFormatParameter("sprop-parameter-sets")) != null) {
                ByteArrayOutputStream nals = new ByteArrayOutputStream();
                for (String s : spropParameterSets.split(",")) {
                    byte[] nal;
                    if (s == null || s.length() == 0 || (nal = Base64.decode((String)s)) == null || nal.length == 0) continue;
                    nals.write(H264.NAL_PREFIX);
                    nals.write(nal);
                }
                if (nals.size() != 0) {
                    for (int i = 0; i < 64; ++i) {
                        nals.write(0);
                    }
                    FFmpeg.avcodec_decode_video((long)this.avctx, (long)this.avframe.getPtr(), (boolean[])this.got_picture, (byte[])nals.toByteArray(), (int)nals.size());
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Failed to handle format parameters", t);
        }
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        if (this.avframe != null) {
            this.avframe.free();
            this.avframe = null;
        }
        this.avframe = new AVFrame();
        long avcodec = FFmpeg.avcodec_find_decoder((int)FFmpeg.CODEC_ID_H264);
        if (avcodec == 0L) {
            throw new ResourceUnavailableException("Could not find H.264 decoder.");
        }
        this.avctx = FFmpeg.avcodec_alloc_context3((long)avcodec);
        FFmpeg.avcodeccontext_set_workaround_bugs((long)this.avctx, (int)1);
        FFmpeg.avcodeccontext_add_flags2((long)this.avctx, (int)32768);
        if (FFmpeg.avcodec_open2((long)this.avctx, (long)avcodec, (String[])new String[0]) < 0) {
            throw new RuntimeException("Could not open H.264 decoder.");
        }
        this.gotPictureAtLeastOnce = false;
        this.opened = true;
        super.open();
        this.handleFmtps();
    }

    public synchronized int process(Buffer in, Buffer out) {
        long pts;
        if (!this.checkInputBuffer(in)) {
            return 1;
        }
        if (this.isEOM(in) || !this.opened) {
            this.propagateEOM(out);
            return 0;
        }
        if (in.isDiscard()) {
            out.setDiscard(true);
            return 0;
        }
        this.got_picture[0] = false;
        FFmpeg.avcodec_decode_video((long)this.avctx, (long)this.avframe.getPtr(), (boolean[])this.got_picture, (byte[])((byte[])in.getData()), (int)in.getLength());
        if (!this.got_picture[0]) {
            if ((in.getFlags() & 0x800) != 0 && this.keyFrameControl != null) {
                this.keyFrameControl.requestKeyFrame(!this.gotPictureAtLeastOnce);
            }
            out.setDiscard(true);
            return 0;
        }
        this.gotPictureAtLeastOnce = true;
        int width = FFmpeg.avcodeccontext_get_width((long)this.avctx);
        int height = FFmpeg.avcodeccontext_get_height((long)this.avctx);
        if (width > 0 && height > 0 && (this.width != width || this.height != height)) {
            this.width = width;
            this.height = height;
            Dimension outSize = new Dimension(this.width, this.height);
            VideoFormat inFormat = (VideoFormat)in.getFormat();
            float outFrameRate = this.ensureFrameRate(inFormat.getFrameRate());
            this.outputFormat = new AVFrameFormat(outSize, outFrameRate, 0);
        }
        out.setFormat(this.outputFormat);
        if (out.getData() != this.avframe) {
            out.setData((Object)this.avframe);
        }
        if ((pts = Long.MIN_VALUE) == Long.MIN_VALUE) {
            out.setTimeStamp(in.getTimeStamp());
        } else {
            out.setTimeStamp(pts);
            int outFlags = out.getFlags();
            outFlags |= 0x100;
            out.setFlags(outFlags &= 0xFFFFEF7F);
        }
        return 0;
    }

    public Format setInputFormat(Format format) {
        Format setFormat = super.setInputFormat(format);
        if (setFormat != null) {
            this.reset();
        }
        return setFormat;
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        this.keyFrameControl = keyFrameControl;
    }
}

