/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.time.Duration;
import java.time.Instant;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Processor;
import org.jitsi.utils.logging.Logger;

public class ProcessorUtility
implements ControllerListener {
    private static final Logger logger = Logger.getLogger(ProcessorUtility.class);
    private final Object stateLock = new Object();
    private boolean failed = false;
    private static final int WAIT_TIMEOUT = 10;

    private Object getStateLock() {
        return this.stateLock;
    }

    private void setFailed(boolean failed) {
        this.failed = failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent ce) {
        Object stateLock;
        Object object = stateLock = this.getStateLock();
        synchronized (object) {
            if (ce instanceof ControllerClosedEvent) {
                if (ce instanceof ControllerErrorEvent) {
                    logger.warn((Object)("ControllerErrorEvent: " + ce));
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ControllerClosedEvent: " + ce));
                }
                this.setFailed(true);
            }
            stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized boolean waitForState(Processor processor, int state) {
        Object stateLock;
        processor.addControllerListener((ControllerListener)this);
        this.setFailed(false);
        if (state == 180) {
            processor.configure();
        } else if (state == 300) {
            processor.realize();
        }
        boolean interrupted = false;
        Object object = stateLock = this.getStateLock();
        // MONITORENTER : object
        while (processor.getState() < state && !this.failed) {
            try {
                Instant startTime = Instant.now();
                stateLock.wait(10000L);
                if (Duration.between(startTime, Instant.now()).getSeconds() < 10L) continue;
                this.setFailed(true);
            }
            catch (InterruptedException ie) {
                logger.warn((Object)("Interrupted while waiting on Processor " + processor + " for state " + state), (Throwable)ie);
                interrupted = true;
            }
        }
        // MONITOREXIT : object
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        processor.removeControllerListener((ControllerListener)this);
        if (this.failed) return false;
        return true;
    }
}

