/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.utils;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(MVStoreUtils.class);
    private static final List<MVStoreOpening.Hook> hooks = new CopyOnWriteArrayList<MVStoreOpening.Hook>();

    public static void addHook(MVStoreOpening.Hook hook) {
        hooks.add(hook);
    }

    public static MVStore open(File file, String operationName, Function<MVStore.Builder, MVStore.Builder> customizer) {
        return new MVStoreOpeningImpl(file, operationName, customizer).open();
    }

    public static <T> T open(File file, String operationName, Function<MVStore.Builder, MVStore.Builder> customizer, Function<MVStore, T> handler) {
        return new MVStoreOpeningImpl(file, operationName, customizer).open(handler);
    }

    public static <K, V> MVMap<K, V> openMap(MVStore store, String name, MVMap.MapBuilder<MVMap<K, V>, K, V> builder) {
        try {
            return store.openMap(name, builder);
        }
        catch (Throwable error) {
            store.removeMap(name);
            log.warn("Open MVStore Map[{}] error,Maybe the file [{}] is broken?", new Object[]{name, store.getFileStore().getFileName(), error});
            return store.openMap(name, builder);
        }
    }

    private static class MVStoreOpeningImpl
    implements MVStoreOpening {
        private final File file;
        private final String operation;
        private final Function<MVStore.Builder, MVStore.Builder> customizer;
        private File backup;
        private Throwable error;

        private void fireEvent(MVStoreOpening.Action action) {
            if (!hooks.isEmpty()) {
                for (MVStoreOpening.Hook hook : hooks) {
                    hook.on(action, this);
                }
            }
        }

        public MVStore open() {
            return (MVStore)this.open(Function.identity());
        }

        public <T> T open(Function<MVStore, T> handler) {
            if (!this.file.getParentFile().exists()) {
                boolean bl = this.file.getParentFile().mkdirs();
            }
            try {
                MVStore store = this.open0(this.customizer);
                T res = handler.apply(store);
                this.fireEvent(MVStoreOpening.Action.success);
                return res;
            }
            catch (Throwable e) {
                this.error = null;
                if (this.file.exists()) {
                    return this.tryRecovery(this.customizer, e, handler);
                }
                throw e;
            }
        }

        private File backup() {
            File backup = new File(this.file.getParentFile(), this.file.getName() + ".backup." + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss")));
            this.file.renameTo(backup);
            return backup;
        }

        private <T> T tryRecovery(Function<MVStore.Builder, MVStore.Builder> customizer, Throwable reason, Function<MVStore, T> handler) {
            try {
                log.warn("try recovery mvstore:{}", (Object)this.file);
                MVStoreTool.compactCleanUp((String)this.file.getAbsolutePath());
                MVStoreTool.compact((String)this.file.getAbsolutePath(), (boolean)false);
                log.warn("recovery mvstore:{} complete", (Object)this.file);
                return handler.apply(this.open0(customizer));
            }
            catch (Throwable err) {
                err.addSuppressed(reason);
                this.error = err;
                this.fireEvent(MVStoreOpening.Action.recoverFail);
                try {
                    this.error = null;
                    this.backup = this.backup();
                    this.fireEvent(MVStoreOpening.Action.backup);
                }
                catch (Throwable error) {
                    error.addSuppressed(err);
                    this.error = err;
                    this.fireEvent(MVStoreOpening.Action.backupFail);
                }
                boolean ignore = this.file.delete();
                return handler.apply(this.open0(customizer));
            }
        }

        private MVStore open0(Function<MVStore.Builder, MVStore.Builder> customizer) {
            MVStore.Builder builder = new MVStore.Builder().fileName(this.file.getAbsolutePath()).autoCommitBufferSize(65536).compress().keysPerPage(1024).cacheSize(64);
            builder = customizer.apply(builder);
            return builder.open();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public String getOperation() {
            return this.operation;
        }

        public Function<MVStore.Builder, MVStore.Builder> getCustomizer() {
            return this.customizer;
        }

        @Override
        public File getBackup() {
            return this.backup;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        public MVStoreOpeningImpl(File file, String operation, Function<MVStore.Builder, MVStore.Builder> customizer) {
            this.file = file;
            this.operation = operation;
            this.customizer = customizer;
        }
    }

    public static interface MVStoreOpening {
        public File getFile();

        public String getOperation();

        public File getBackup();

        public Throwable getError();

        public static enum Action {
            success,
            recoverFail,
            backup,
            backupFail;

        }

        public static interface Hook {
            public void on(Action var1, MVStoreOpening var2);
        }
    }
}

