/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.utils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimpleDeviceMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.supports.official.DeviceMetadataParser;
import org.springframework.core.ResolvableType;

public class DeviceMetadataUtils {
    public static List<PropertyMetadata> convertToProperties(Map<String, Object> value) {
        return value.entrySet().stream().filter(e -> e.getValue() != null).map(entry -> {
            SimplePropertyMetadata metadata = new SimplePropertyMetadata();
            metadata.setId((String)entry.getKey());
            metadata.setName((String)entry.getKey());
            metadata.setValueType(DeviceMetadataParser.withType(ResolvableType.forType(entry.getValue().getClass())));
            return metadata;
        }).collect(Collectors.toList());
    }

    public static DeviceMetadata difference(DeviceMetadata left, DeviceMetadata right) {
        SimpleDeviceMetadata metadata = new SimpleDeviceMetadata();
        metadata.setId(right.getId());
        metadata.setName(right.getName());
        metadata.setExpands(right.getExpands());
        metadata.setDescription(right.getDescription());
        for (PropertyMetadata meta : right.getProperties()) {
            if (left.getPropertyOrNull(meta.getId()) != null) continue;
            metadata.addProperty(meta);
        }
        for (PropertyMetadata meta : right.getEvents()) {
            if (left.getEventOrNull(meta.getId()) != null) continue;
            metadata.addEvent((EventMetadata)meta);
        }
        for (PropertyMetadata meta : right.getFunctions()) {
            if (left.getFunctionOrNull(meta.getId()) != null) continue;
            metadata.addFunction((FunctionMetadata)meta);
        }
        for (PropertyMetadata meta : right.getTags()) {
            if (left.getTagOrNull(meta.getId()) != null) continue;
            metadata.addTag(meta);
        }
        return metadata;
    }
}

