/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cache;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;
import org.jetlinks.core.cache.FileQueue;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.utils.ConverterUtils;
import org.jetlinks.supports.cache.ConcurrencyMVStoreQueue;
import org.jetlinks.supports.utils.MVStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class MVStoreQueue<T>
implements FileQueue<T> {
    private static final Logger log = LoggerFactory.getLogger(MVStoreQueue.class);
    private static final AtomicLongFieldUpdater<MVStoreQueue> INDEX = AtomicLongFieldUpdater.newUpdater(MVStoreQueue.class, "index");
    MVStore store;
    private MVMap<Long, T> mvMap;
    private volatile long index = 0L;
    private boolean closed = false;
    private final String name;
    private final Path storageFile;
    private final Map<String, Object> options;
    private final AtomicBoolean loading = new AtomicBoolean();
    private final ReentrantReadWriteLock loadLock = new ReentrantReadWriteLock();
    private final ReentrantLock pollLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();

    MVStoreQueue(Path filePath, String name, Map<String, Object> options) {
        Files.createDirectories(filePath, new FileAttribute[0]);
        this.name = name;
        this.storageFile = filePath.resolve(name);
        this.options = options;
        this.open();
    }

    MVStoreQueue(MVMap<Long, T> mvMap) {
        this.storageFile = null;
        this.name = mvMap.getName();
        this.options = null;
        this.mvMap = mvMap;
        if (!mvMap.isEmpty()) {
            INDEX.set(this, (Long)mvMap.lastKey());
        }
    }

    protected void open() {
        if (!this.loading.compareAndSet(false, true) || this.closed) {
            return;
        }
        this.loadLock.writeLock().lock();
        try {
            try {
                if (this.store != null && !this.store.isClosed()) {
                    this.store.close(1000);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.store = MVStoreUtils.open(this.storageFile.toFile(), this.name, builder -> builder.cacheSize(16).autoCommitBufferSize(32768).backgroundExceptionHandler((t, e) -> log.warn("{} UncaughtException", (Object)this.name, (Object)e)).compress(), store -> {
                Object type = this.options.get("valueType");
                MVMap.Builder mapBuilder = new MVMap.Builder();
                if (type instanceof DataType) {
                    mapBuilder.valueType((DataType)type);
                }
                this.mvMap = MVStoreUtils.openMap(store, "queue", mapBuilder);
                if (!this.mvMap.isEmpty() && this.index == 0L) {
                    INDEX.set(this, (Long)this.mvMap.lastKey());
                }
                return store;
            });
        }
        finally {
            this.loadLock.writeLock().unlock();
            this.loading.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <X> X operationInStore(Callable<X> call) {
        Throwable error;
        if (this.store == null) {
            return call.call();
        }
        int retry = 0;
        do {
            this.loadLock.readLock().lock();
            try {
                X x = call.call();
                return x;
            }
            catch (Throwable e) {
                error = e;
                if (retry == 0) {
                    log.warn("operation mvstore [{}] failed! try reopening...", (Object)this.storageFile, (Object)e);
                }
            }
            finally {
                this.loadLock.readLock().unlock();
            }
            this.open();
        } while (retry++ == 0);
        throw error;
    }

    public void flush() {
        if (this.store.isClosed()) {
            return;
        }
        this.store.compactFile((int)Duration.ofSeconds(30L).toMillis());
    }

    public T removeFirst() {
        this.checkClose();
        this.pollLock.lock();
        try {
            Object object = this.operationInStore(() -> {
                Long key = (Long)this.mvMap.firstKey();
                return key == null ? null : this.mvMap.remove((Object)key);
            });
            return (T)object;
        }
        finally {
            this.pollLock.unlock();
        }
    }

    public T removeLast() {
        this.checkClose();
        this.pollLock.lock();
        try {
            Object object = this.operationInStore(() -> {
                Long key = (Long)this.mvMap.lastKey();
                return key == null ? null : this.mvMap.remove((Object)key);
            });
            return (T)object;
        }
        finally {
            this.pollLock.unlock();
        }
    }

    public synchronized void close() {
        if (this.closed || this.store == null || this.store.isClosed()) {
            return;
        }
        if (this.size() < 1000000) {
            this.store.close(-1);
        } else {
            this.store.close(20000);
        }
        this.closed = true;
    }

    private void checkClose() {
        if (this.closed) {
            throw new IllegalStateException("file queue " + this.name + " is closed");
        }
    }

    public int size() {
        this.checkClose();
        return this.operationInStore(() -> this.mvMap.size());
    }

    public boolean isEmpty() {
        this.checkClose();
        return this.operationInStore(() -> this.mvMap.isEmpty());
    }

    public boolean contains(Object o) {
        this.checkClose();
        return this.operationInStore(() -> this.mvMap.containsValue(o));
    }

    @Nonnull
    public Iterator<T> iterator() {
        this.checkClose();
        final Cursor cursor = this.mvMap.cursor(null, null, false);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public T next() {
                Object next = cursor.getValue();
                cursor.next();
                return next;
            }

            @Override
            public void remove() {
                MVStoreQueue.this.mvMap.remove(cursor.getKey());
            }
        };
    }

    @Nonnull
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        this.checkClose();
        return this.stream().toArray(i -> a);
    }

    public boolean add(T t) {
        this.checkClose();
        if (null == t) {
            return false;
        }
        this.writeLock.lock();
        try {
            this.doAdd(t);
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    private void doAdd(T value) {
        this.operationInStore(() -> {
            this.doAdd0(value);
            return null;
        });
    }

    private void doAdd0(T value) {
        Object old;
        while ((old = this.mvMap.putIfAbsent((Object)INDEX.incrementAndGet(this), value)) != null) {
        }
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove unsupported");
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        this.checkClose();
        return this.mvMap.values().containsAll(c);
    }

    public boolean addAll(@Nonnull Collection<? extends T> c) {
        this.checkClose();
        this.writeLock.lock();
        try {
            boolean bl = this.operationInStore(() -> {
                for (Object t : c) {
                    this.doAdd0(t);
                }
                return true;
            });
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException("removeAll unsupported");
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException("retainAll unsupported");
    }

    public void clear() {
        if (this.closed) {
            return;
        }
        this.operationInStore(() -> {
            this.mvMap.clear();
            INDEX.set(this, 0L);
            return null;
        });
    }

    public boolean offer(T t) {
        this.checkClose();
        return this.add(t);
    }

    public T remove() {
        this.checkClose();
        T data = this.poll();
        if (data == null) {
            throw new NoSuchElementException("No such element in file " + this.storageFile);
        }
        return data;
    }

    public T poll() {
        Object removed;
        if (this.closed) {
            return null;
        }
        try {
            this.pollLock.lock();
            removed = this.operationInStore(() -> {
                Long key = (Long)this.mvMap.firstKey();
                return key == null ? null : this.mvMap.remove((Object)key);
            });
        }
        finally {
            this.pollLock.unlock();
        }
        return (T)removed;
    }

    public T element() {
        if (this.mvMap.isClosed()) {
            return null;
        }
        T data = this.peek();
        if (data == null) {
            throw new NoSuchElementException("No such element in file " + this.storageFile);
        }
        return data;
    }

    public T peek() {
        this.checkClose();
        return (T)this.operationInStore(() -> this.mvMap.get(this.mvMap.firstKey()));
    }

    static class Builder<T>
    implements FileQueue.Builder<T> {
        private String name;
        private Path path;
        private final Map<String, Object> options = new HashMap<String, Object>();

        Builder() {
        }

        public FileQueue.Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public FileQueue.Builder<T> codec(Codec<T> codec) {
            return this;
        }

        public FileQueue.Builder<T> path(Path path) {
            this.path = path;
            return this;
        }

        public FileQueue.Builder<T> options(Map<String, Object> options) {
            this.options.putAll(options);
            return this;
        }

        public FileQueue.Builder<T> option(String key, Object value) {
            this.options.put(key, value);
            return this;
        }

        public <V> FileQueue.Builder<T> option(ConfigKey<V> key, V value) {
            this.options.put(key.getName(), value);
            return this;
        }

        public FileQueue<T> build() {
            Assert.hasText((String)this.name, (String)"name must not be empty");
            Assert.notNull((Object)this.path, (String)"path must not be null");
            Assert.notNull((Object)this.path, (String)"codec must not be null");
            int concurrency = (Integer)ConverterUtils.convert((Object)this.options.getOrDefault("concurrency", 1), Integer.class);
            if (concurrency > 1) {
                return new ConcurrencyMVStoreQueue(this.path, this.name, this.options, (Integer)ConverterUtils.convert((Object)this.options.get("concurrency"), Integer.class));
            }
            return new MVStoreQueue(this.path, this.name, this.options);
        }
    }
}

