/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.switcher;

import java.util.Deque;
import java.util.LinkedList;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.datasource.switcher.DatabaseSwitcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseSwitcher
implements DatabaseSwitcher {
    private static final String DEFAULT_DATASOURCE_ID = DatabaseSwitcher.class.getName() + "_default_";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected String getDefaultDataSourceIdKey() {
        return DEFAULT_DATASOURCE_ID;
    }

    protected Deque<String> getUsedHistoryQueue() {
        return (Deque)ThreadLocalUtils.get((String)(DefaultDatabaseSwitcher.class.getName() + "_queue"), LinkedList::new);
    }

    @Override
    public void useLast() {
        if (this.getUsedHistoryQueue().isEmpty()) {
            return;
        }
        this.getUsedHistoryQueue().removeLast();
        if (this.logger.isDebugEnabled()) {
            String current = this.currentDatabase();
            if (null != current) {
                this.logger.debug("try use database : {}", (Object)this.currentDatabase());
            } else {
                this.logger.debug("try use last default database");
            }
        }
    }

    @Override
    public void use(String dataSourceId) {
        this.getUsedHistoryQueue().addLast(dataSourceId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("try use database : {}", (Object)dataSourceId);
        }
    }

    @Override
    public void useDefault() {
        this.getUsedHistoryQueue().addLast(this.getDefaultDataSourceIdKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("try use default database");
        }
    }

    @Override
    public String currentDatabase() {
        if (this.getUsedHistoryQueue().isEmpty()) {
            return null;
        }
        String activeId = this.getUsedHistoryQueue().getLast();
        if (this.getDefaultDataSourceIdKey().equals(activeId)) {
            return null;
        }
        return activeId;
    }

    @Override
    public void reset() {
        this.getUsedHistoryQueue().clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reset database used history");
        }
    }
}

