/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.config.InSpringDynamicDataSourceConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class InSpringDynamicDataSourceConfigRepository
implements DynamicDataSourceConfigRepository<InSpringDynamicDataSourceConfig>,
BeanPostProcessor {
    private Map<String, InSpringDynamicDataSourceConfig> configMap = new HashMap<String, InSpringDynamicDataSourceConfig>();

    @Override
    public List<InSpringDynamicDataSourceConfig> findAll() {
        return new ArrayList<InSpringDynamicDataSourceConfig>(this.configMap.values());
    }

    @Override
    public InSpringDynamicDataSourceConfig findById(String dataSourceId) {
        return this.configMap.get(dataSourceId);
    }

    @Override
    public InSpringDynamicDataSourceConfig add(InSpringDynamicDataSourceConfig config) {
        return this.configMap.put(config.getId(), config);
    }

    @Override
    public InSpringDynamicDataSourceConfig remove(String dataSourceId) {
        return this.configMap.remove(dataSourceId);
    }

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        if (o instanceof DataSource) {
            InSpringDynamicDataSourceConfig config = new InSpringDynamicDataSourceConfig();
            config.setId(s);
            config.setBeanName(s);
            config.setName(s);
            this.add(config);
        }
        return o;
    }
}

