/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import org.hswebframework.web.datasource.DatabaseType;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.DynamicDataSourceService;
import org.hswebframework.web.datasource.exception.DataSourceNotFoundException;
import org.hswebframework.web.datasource.switcher.DataSourceSwitcher;
import org.hswebframework.web.datasource.switcher.DatabaseSwitcher;
import org.hswebframework.web.datasource.switcher.DefaultDataSourceSwitcher;
import org.hswebframework.web.datasource.switcher.DefaultDatabaseSwitcher;
import org.hswebframework.web.datasource.switcher.DefaultTableSwitcher;
import org.hswebframework.web.datasource.switcher.TableSwitcher;

public final class DataSourceHolder {
    private static final DataSourceSwitcher defaultSwitcher;
    static volatile DataSourceSwitcher dataSourceSwitcher;
    static volatile DynamicDataSourceService dynamicDataSourceService;
    static volatile TableSwitcher tableSwitcher;
    static volatile DatabaseSwitcher databaseSwitcher;

    public static void checkDynamicDataSourceReady() {
        if (dynamicDataSourceService == null) {
            throw new UnsupportedOperationException("dataSourceService not ready");
        }
    }

    public static DataSourceSwitcher switcher() {
        return dataSourceSwitcher;
    }

    public static TableSwitcher tableSwitcher() {
        return tableSwitcher;
    }

    public static DatabaseSwitcher databaseSwitcher() {
        return databaseSwitcher;
    }

    public static DynamicDataSource defaultDataSource() {
        DataSourceHolder.checkDynamicDataSourceReady();
        return dynamicDataSourceService.getDefaultDataSource();
    }

    public static DynamicDataSource dataSource(String dataSourceId) {
        DataSourceHolder.checkDynamicDataSourceReady();
        return dynamicDataSourceService.getDataSource(dataSourceId);
    }

    public static DynamicDataSource currentDataSource() {
        String id = dataSourceSwitcher.currentDataSourceId();
        if (id == null) {
            return DataSourceHolder.defaultDataSource();
        }
        DataSourceHolder.checkDynamicDataSourceReady();
        return dynamicDataSourceService.getDataSource(id);
    }

    public static boolean currentIsDefault() {
        return dataSourceSwitcher.currentDataSourceId() == null;
    }

    public static boolean existing(String id) {
        try {
            DataSourceHolder.checkDynamicDataSourceReady();
            return dynamicDataSourceService.getDataSource(id) != null;
        }
        catch (DataSourceNotFoundException e) {
            return false;
        }
    }

    public static boolean currentExisting() {
        if (DataSourceHolder.currentIsDefault()) {
            return true;
        }
        try {
            return DataSourceHolder.currentDataSource() != null;
        }
        catch (DataSourceNotFoundException e) {
            return false;
        }
    }

    public static DatabaseType currentDatabaseType() {
        return DataSourceHolder.currentDataSource().getType();
    }

    public static DatabaseType defaultDatabaseType() {
        return DataSourceHolder.defaultDataSource().getType();
    }

    static {
        dataSourceSwitcher = defaultSwitcher = new DefaultDataSourceSwitcher();
        tableSwitcher = new DefaultTableSwitcher();
        databaseSwitcher = new DefaultDatabaseSwitcher();
    }
}

