/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.test.EventTestHelper;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class FlowableEventRule
implements TestRule {
    protected String configurationResource = "flowable.eventregistry.cfg.xml";
    protected String deploymentId;
    protected EventRegistryEngineConfiguration eventEngineConfiguration;
    protected EventRegistryEngine eventRegistryEngine;
    protected EventRepositoryService repositoryService;

    public FlowableEventRule() {
    }

    public FlowableEventRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableEventRule(EventRegistryEngine eventRegistryEngine) {
        this.setEventRegistryEngine(eventRegistryEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableEventRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableEventRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableEventRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableEventRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    FlowableEventRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.eventRegistryEngine == null) {
            this.initializeEventRegistryEngine();
        }
        if (this.eventEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureEventRegistryEngine();
        try {
            this.deploymentId = EventTestHelper.annotationDeploymentSetUp(this.repositoryService, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    protected void initializeEventRegistryEngine() {
        this.eventRegistryEngine = EventTestHelper.getEventRegistryEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.eventEngineConfiguration = this.eventRegistryEngine.getEventRegistryEngineConfiguration();
        this.repositoryService = this.eventRegistryEngine.getEventRepositoryService();
    }

    protected void configureEventRegistryEngine() {
    }

    protected void finished(Description description) {
        try {
            EventTestHelper.annotationDeploymentTearDown(this.repositoryService, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public EventRegistryEngine getEventRegistryEngine() {
        return this.eventRegistryEngine;
    }

    public void setEventRegistryEngine(EventRegistryEngine eventRegistryEngine) {
        this.eventRegistryEngine = eventRegistryEngine;
        this.initializeServices();
    }

    public EventRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(EventRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void EventRegistryEngineConfiguration(EventRegistryEngineConfiguration eventEngineConfiguration) {
        this.eventEngineConfiguration = eventEngineConfiguration;
    }
}

