/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.source;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.eluder.coveralls.maven.plugin.source.AbstractSourceLoader;

public class ScanSourceLoader
extends AbstractSourceLoader {
    private final Map<String, String[]> cache = new HashMap<String, String[]>();
    private final File sourceDirectory;

    public ScanSourceLoader(File base, File sourceDirectory, String sourceEncoding) {
        super(base.toURI(), sourceDirectory.toURI(), sourceEncoding);
        this.sourceDirectory = sourceDirectory;
    }

    @Override
    protected InputStream locate(String sourceFile) throws IOException {
        File file = new File(this.sourceDirectory, this.getFileName(sourceFile));
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not file");
            }
            return new BufferedInputStream(new FileInputStream(file));
        }
        return null;
    }

    private String[] scanFor(String extension) {
        if (!this.cache.containsKey(extension)) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.sourceDirectory);
            scanner.addDefaultExcludes();
            scanner.setIncludes(new String[]{"**/*." + extension});
            scanner.scan();
            this.cache.put(extension, scanner.getIncludedFiles());
        }
        return this.cache.get(extension);
    }

    @Override
    protected String getFileName(String sourceFile) {
        String[] matchingExtensionFiles;
        String extension = FileUtils.extension((String)sourceFile);
        for (String matchingExtensionFile : matchingExtensionFiles = this.scanFor(extension)) {
            if (!SelectorUtils.matchPath((String)("**/" + sourceFile), (String)matchingExtensionFile, (boolean)true)) continue;
            return matchingExtensionFile;
        }
        return sourceFile;
    }
}

