/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.source;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eluder.coveralls.maven.plugin.source.AbstractSourceLoader;

public class DirectorySourceLoader
extends AbstractSourceLoader {
    private final File sourceDirectory;

    public DirectorySourceLoader(File base, File sourceDirectory, String sourceEncoding) {
        super(base.toURI(), sourceDirectory.toURI(), sourceEncoding);
        this.sourceDirectory = sourceDirectory;
    }

    @Override
    protected InputStream locate(String sourceFile) throws IOException {
        File file = new File(this.sourceDirectory, sourceFile);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not file");
            }
            return new BufferedInputStream(new FileInputStream(file));
        }
        return null;
    }
}

